<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Config;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Doctrine\ORM\EntityManagerInterface;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsWastage;
use PrestaShop\Module\ProductPriceBySize\Repository\WastageRepository;
use PrestaShop\PrestaShop\Core\Form\FormDataProviderInterface;

/**
 * Provider ir responsible for providing form data, in this case it's as simple as using configuration to do that
 */
class WastageFormDataProvider implements FormDataProviderInterface
{
    protected $context;

    protected $id;

    protected $entityManager;

    protected $wastageRepository;

    protected $languages = [];

    public function __construct(
        \Context $context,
        EntityManagerInterface $entityManager,
        WastageRepository $wastageRepository,
        array $languages) {
        $this->context = $context;
        $this->entityManager = $entityManager;
        $this->wastageRepository = $wastageRepository;
        $this->languages = $languages;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getData(): array
    {
        if (empty($this->id)) {
            return [];
        }
        $wastage = $this->wastageRepository->find($this->id);
        if (empty($wastage)) {
            return [];
        }
        $data['id'] = $wastage->getId();
        $data['value'] = $wastage->getValue();

        return $data;
    }

    public function setData(array $data): array
    {
        if (!empty($data['id'])) {
            $wastage = $this->wastageRepository->find((int) $data['id']);
        } else {
            $wastage = new PpbsWastage();
        }
        $wastage->setValue((int) $data['value']);
        $this->entityManager->persist($wastage);
        $this->entityManager->flush();

        return [];
    }

    public function delete(): bool
    {
        $this->wastageRepository->delete($this->id);

        return true;
    }
}
