<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Product\Pap;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Form\Admin\Type\Material\MaterialChoiceTableType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

class OptionsFormType extends PackFormType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);
        $builder
            ->add('pack_type', ChoiceType::class, [
                'label' => $this->trans(
                    'Choose the type of area packs',
                    'Modules.Productpricebysize.Admin'
                ),
                'required' => true,
                'choices' => $this->packTypeChoices,
            ])
            ->add('calculation_type', ChoiceType::class, [
                'label' => $this->trans(
                    'Price calculation type',
                    'Modules.Productpricebysize.Admin'
                ),
                'required' => true,
                'choices' => $this->calculationTypeChoices,
            ])
            ->add('id_unit', ChoiceType::class, [
                'label' => $this->trans(
                    'Unit for area',
                    'Modules.Productpricebysize.Admin'
                ),
                'required' => true,
                'choices' => $this->unitChoices,
            ])
            ->add('product_unit', MaterialChoiceTableType::class, [
                'label' => $this->trans('or allow the customer to switch between the units:', 'Modules.Productpricebysize.Admin'),
                'help' => $this->trans('', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => [],
                'choices' => $this->unitChoices,
            ])
            ->add('product_wastage', MaterialChoiceTableType::class, [
                'label' => $this->trans('Show the following wastage options %', 'Modules.Productpricebysize.Admin'),
                'help' => $this->trans('', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => [],
                'choices' => $this->wastageChoices,
            ]);

        $this->addPackForm($builder, $this->packType);
    }
}
