<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Product\Pap;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\Module\ProductPriceBySize\Enum\PackType;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductPackRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductRepository;
use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;
use Symfony\Component\Validator\Constraints\Type;

class PackFormType extends TranslatorAwareType
{
    protected $unitChoices;

    protected $packTypeChoices;

    protected $productRepository;

    protected $productPackRepository;

    protected $calculationTypeChoices;

    protected $wastageChoices;

    protected $data;

    protected $packType;

    public function __construct(
        $translator,
        array $locales,
        array $data,
        array $unitChoices,
        array $packTypeChoices,
        array $calculationTypeChoices,
        array $wastageChoices,
        ProductRepository $productRepository,
        ProductPackRepository $productPackRepository) {
        parent::__construct($translator, $locales);
        $this->unitChoices = $unitChoices;
        $this->packTypeChoices = $packTypeChoices;
        $this->productRepository = $productRepository;
        $this->productPackRepository = $productPackRepository;
        $this->calculationTypeChoices = $calculationTypeChoices;
        $this->wastageChoices = $wastageChoices;
        $this->data = $data;

        $ppbsProduct = $this->productRepository->find((int) $this->data['id_product']);

        if (!empty($ppbsProduct)) {
            $productPack = $this->productPackRepository->findOneBy([
                'idProduct' => $ppbsProduct->getId(),
                'idProductAttribute' => 0,
            ]);
        }

        $this->packType = PackType::NORMAL;

        if (!empty($productPack)) {
            $this->packType = $ppbsProduct->getPapType();
        }
    }

    protected function addPackForm(FormBuilderInterface &$builder, string $packType): void
    {
        if ($packType == PackType::NORMAL) {
            $builder
                ->add('pack_area', NumberType::class, [
                    'label' => $this->trans('Pack Area', 'Modules.Productpricebysize.Admin'),
                    'required' => false,
                    'empty_data' => '0',
                    'constraints' => [
                        new GreaterThanOrEqual(['value' => 0]),
                        new Type(['type' => 'numeric']),
                    ],
                ])
                ->add('area_price', NumberType::class, [
                    'label' => $this->trans('Area Price', 'Modules.Productpricebysize.Admin'),
                    'required' => false,
                    'empty_data' => '0',
                    'constraints' => [
                        new GreaterThanOrEqual(['value' => 0]),
                        new Type(['type' => 'numeric']),
                    ],
                ]);
        }

        if ($packType == PackType::ROLLS) {
            $builder
                ->add('roll_height', NumberType::class, [
                    'label' => $this->trans('Roll Height', 'Modules.Productpricebysize.Admin'),
                    'required' => false,
                    'empty_data' => '0',
                    'constraints' => [
                        new GreaterThanOrEqual(['value' => 0]),
                        new Type(['type' => 'numeric']),
                    ],
                ])
                ->add('roll_width', NumberType::class, [
                    'label' => $this->trans('Roll Width', 'Modules.Productpricebysize.Admin'),
                    'required' => false,
                    'empty_data' => '0',
                    'constraints' => [
                        new GreaterThanOrEqual(['value' => 0]),
                        new Type(['type' => 'numeric']),
                    ],
                ])
                ->add('pattern_repeat', NumberType::class, [
                    'label' => $this->trans('Pattern Repeat', 'Modules.Productpricebysize.Admin'),
                    'required' => false,
                    'empty_data' => '0',
                    'constraints' => [
                        new GreaterThanOrEqual(['value' => 0]),
                        new Type(['type' => 'numeric']),
                    ],
                ]);
        }

        if ($packType == PackType::PAINT) {
            $builder
                ->add('coverage', NumberType::class, [
                    'label' => $this->trans('Coverage Area', 'Modules.Productpricebysize.Admin'),
                    'required' => false,
                    'empty_data' => '0',
                    'constraints' => [
                        new GreaterThanOrEqual(['value' => 0]),
                        new Type(['type' => 'numeric']),
                    ],
                ]);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $ppbsProduct = $this->productRepository->find((int) $this->data['id_product']);
        if (!empty($ppbsProduct)) {
            $productPack = $this->productPackRepository->findOneBy([
                'idProduct' => $ppbsProduct->getId(),
                'idProductAttribute' => 0,
            ]);
        }
        $packType = PackType::NORMAL;
        if (!empty($productPack)) {
            $packType = $ppbsProduct->getPapType();
        }

        $builder
            ->add('id_product', HiddenType::class, [
                'required' => false,
            ])
            ->add('id_product_attribute', HiddenType::class, [
                'required' => false,
            ]);
    }
}
