<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Product\Ppbs;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;
use Symfony\Component\Validator\Constraints\Type;

class AreaPriceFormType extends TranslatorAwareType
{
    protected $requestStack;

    private $priceImpactTypeChoices;

    public function __construct($translator,
        array $locales,
        array $priceImpactTypeChoices) {
        parent::__construct($translator, $locales);
        $this->priceImpactTypeChoices = $priceImpactTypeChoices;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('idProduct', HiddenType::class, [
                'required' => false,
            ])
            ->add('area_low', NumberType::class, [
                'label' => $this->trans('From Area', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('area_high', NumberType::class, [
                'label' => $this->trans('To Area', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('impact', ChoiceType::class, [
                'label' => $this->trans('Impact on price', 'Modules.Productpricebysize.Admin'),
                'required' => true,
                'choices' => $this->priceImpactTypeChoices,
            ])
            ->add('price', NumberType::class, [
                'label' => $this->trans('Price', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('weight', NumberType::class, [
                'label' => $this->trans('Weight', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ]);
    }
}
