<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Product\Ppbs;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Form\Admin\Type\Material\MaterialChoiceTableType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;
use Symfony\Component\Validator\Constraints\Type;

class OptionsFormType extends TranslatorAwareType
{
    protected $requestStack;

    private $unitChoices;

    public function __construct($translator,
        array $locales,
        array $unitChoices) {
        parent::__construct($translator, $locales);
        $this->unitChoices = $unitChoices;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('idProduct', HiddenType::class, [
                'required' => false,
            ])
            ->add('is_enabled', SwitchType::class, [
                'required' => false,
                'label' => $this->trans('Enabled for this product?', 'Modules.Productpricebysize.Admin'),
                'help' => $this->trans('Enable or disable the module for this product', 'Modules.Productpricebysize.Admin'),
            ])
            ->add('is_attribute_price_area_price', SwitchType::class, [
                'required' => false,
                'label' => $this->trans('Use attribute price in area calculation?', 'Modules.Productpricebysize.Admin'),
                'help' => $this->trans(
                    'When enabled area price (eg price per m2) will include the attribute price',
                    'Modules.Productpricebysize.Admin'
                ),
            ])
            ->add('min_price', NumberType::class, [
                'label' => $this->trans(
                    'Charge Min Price',
                    'Modules.Productpricebysize.Admin'
                ),
                'help' => $this->trans(
                    'If the dynamic price falls below this amount, this amount will be charged',
                    'Modules.Productbundlespro.Admin'
                ),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('min_total_area', NumberType::class, [
                'label' => $this->trans(
                    'Or enforce minimum area',
                    'Modules.Productpricebysize.Admin'
                ),
                'help' => $this->trans(
                    'Impose this area if total dynamic area is below this value',
                    'Modules.Productpricebysize.Admin'
                ),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('setup_fee', NumberType::class, [
                'label' => $this->trans('Apply set up fee', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('id_unit', ChoiceType::class, [
                'label' => $this->trans(
                    'Main unit for price (price per x)',
                    'Modules.Productpricebysize.Admin'
                ),
                'required' => true,
                'choices' => $this->unitChoices,
            ])
            /*->add('is_front_conversion_enabled', SwitchType::class, [
                'required' => false,
                'label' => $this->trans('Convert Units entered by customer?', 'Modules.Productpricebysize.Admin'),
                'help' => $this->trans(
                    'Enable this option to allow customer to enter dimensions in a unit that is different the main unit for price above',
                    'Modules.Productpricebysize.Admin'
                ),
            ])
            ->add('front_conversion_operator', ChoiceType::class, [
                'label' => $this->trans('Conversion formula', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'choices' => [
                    $this->trans('Divide by', 'Modules.Productpricebysize.Admin') => '/',
                    $this->trans('Multiply by', 'Modules.Productpricebysize.Admin') => '*',
                ],
            ])
            ->add('front_conversion_value', NumberType::class, [
                'label' => $this->trans('value', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])*/
            ->add('product_unit', MaterialChoiceTableType::class, [
                'label' => $this->trans('Allow the customer to switch between the units:', 'Modules.Productpricebysize.Admin'),
                'help' => $this->trans('', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => [],
                'choices' => $this->unitChoices,
            ]);
    }
}
