<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Product\Ppbs;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Doctrine\ORM\EntityManagerInterface;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsStock;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\StockRepository;
use PrestaShop\PrestaShop\Core\Form\FormDataProviderInterface;

/**
 * Provider ir responsible for providing form data, in this case it's as simple as using configuration to do that
 */
class StockFormDataProvider implements FormDataProviderInterface
{
    protected $context;

    protected $idProduct;

    protected $idShop;

    protected $entityManager;

    protected $productRepository;

    protected $stockRepository;

    protected $unitRepository;

    public function __construct(
        \Context $context,
        EntityManagerInterface $entityManager,
        ProductRepository $productRepository,
        StockRepository $stockRepository) {
        $this->context = $context;
        $this->entityManager = $entityManager;
        $this->productRepository = $productRepository;
        $this->stockRepository = $stockRepository;
    }

    public function setIdProduct(int $idProduct): self
    {
        $this->idProduct = $idProduct;

        return $this;
    }

    public function setIdShop(int $idShop): self
    {
        $this->idShop = $idShop;

        return $this;
    }

    public function getData(): array
    {
        return [
            'id_product' => $this->idProduct,
        ];
    }

    public function setData(array $data): bool
    {
        if (empty($data['id_product']) || empty($data['data'])) {
            return false;
        }

        $stockData = json_decode($data['data'], true);
        if (empty($stockData)) {
            return false;
        }

        foreach ($stockData as $stock) {
            $ppbsStock = $this->stockRepository->findOneBy([
                'idProduct' => $this->idProduct,
                'idProductAttribute' => $stock['id_product_attribute'],
            ]);
            if (empty($ppbsStock)) {
                $ppbsStock = new PpbsStock();
                $ppbsStock->setIdProduct($this->idProduct);
                $ppbsStock->setIdProductAttribute((int) $stock['id_product_attribute']);
                $ppbsStock->setIdShop($this->idShop);
            }
            $ppbsStock->setStock((float) $stock['stock']);
            $this->entityManager->persist($ppbsStock);
        }

        $this->entityManager->flush();

        return true;
    }
}
