<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Product;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;
use Symfony\Component\Validator\Constraints\Type;

class ProductFieldFormType extends TranslatorAwareType
{
    protected $requestStack;

    private $dimensionChoices;

    private $unitChoices;

    private $fieldTypeChoices;

    public function __construct($translator,
        array $locales,
        array $dimensionChoices,
        array $unitChoices,
        array $fieldTypeChoices) {
        parent::__construct($translator, $locales);
        $this->unitChoices = $unitChoices;
        $this->dimensionChoices = $dimensionChoices;
        $this->fieldTypeChoices = $fieldTypeChoices;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('id_product_field', HiddenType::class, [
                'required' => false,
            ])
            ->add('id_product', HiddenType::class, [
                'required' => false,
            ])
            ->add('id_dimension', ChoiceType::class, [
                'label' => $this->trans('Dimension', 'Modules.Productpricebysize.Admin'),
                'required' => true,
                'choices' => $this->dimensionChoices,
            ])
            ->add('id_unit', ChoiceType::class, [
                'label' => $this->trans('Unit', 'Modules.Productpricebysize.Admin'),
                'required' => true,
                'choices' => $this->unitChoices,
            ])
            ->add('id_field_type', ChoiceType::class, [
                'label' => $this->trans('Display Type', 'Modules.Productpricebysize.Admin'),
                'required' => true,
                'choices' => $this->fieldTypeChoices,
            ])
            ->add('min', NumberType::class, [
                'label' => $this->trans('Min Value', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('max', NumberType::class, [
                'label' => $this->trans('Max Value', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('default_value', NumberType::class, [
                'label' => $this->trans('Default Value', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('ratio', NumberType::class, [
                'label' => $this->trans('Ratio', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('step', NumberType::class, [
                'label' => $this->trans('Step', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0.00',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('decimals', NumberType::class, [
                'label' => $this->trans('Decimals', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '2',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ]);
    }
}
