<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Product;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\ConstraintValidator\Constraints\DefaultLanguage;
use PrestaShopBundle\Form\Admin\Type\TranslatableType;
use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;
use Symfony\Component\Validator\Constraints\Type;

class ProductFieldValueFormType extends TranslatorAwareType
{
    protected $requestStack;

    private $dimensionChoices;

    private $unitChoices;

    private $fieldTypeChoices;

    public function __construct($translator,
        array $locales) {
        parent::__construct($translator, $locales);
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('id_product_field_value', TextType::class, [
                'required' => false,
            ])
            ->add('id_product_field', TextType::class, [
                'required' => false,
            ])
            ->add('value', NumberType::class, [
                'label' => $this->trans('Value', 'Modules.Productpricebysize.Admin'),
                'required' => false,
                'empty_data' => '0',
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                    new Type(['type' => 'numeric']),
                ],
            ])
            ->add('text', TranslatableType::class, [
                'label' => $this->trans('Option Text', 'Modules.Productpricebysize.Admin', []),
                'required' => true,
                'constraints' => [
                    new DefaultLanguage(),
                ],
            ]);
    }
}
