<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Grid\Definition\Factory;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\LinkRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\SubmitRowAction;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollection;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\ActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Grid\Filter\FilterCollection;
use PrestaShop\PrestaShop\Core\Hook\HookDispatcherInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class AreaPriceGridDefinitionFactory extends AbstractGridDefinitionFactory
{
    const GRID_ID = 'ppbs_area_price_x';

    private $idProduct = 0;

    public function __construct(
        HookDispatcherInterface $hookDispatcher,
        RequestStack $requestStack) {
        parent::__construct($hookDispatcher);
        $this->setIdProduct($requestStack);
    }

    /**
     * {@inheritdoc}
     */
    protected function getId()
    {
        return self::GRID_ID;
    }

    /**
     * {@inheritdoc}
     */
    protected function getName()
    {
        return $this->trans('Area Based Prices', [], 'Modules.Productpricebysize.Admin');
    }

    /**
     * {@inheritdoc}
     */
    protected function getColumns()
    {
        return (new ColumnCollection())
            ->add(
                (new DataColumn('area_low'))
                    ->setName($this->trans('From area', [], 'Modules.Productpricebysize.Admin'))
                    ->setOptions([
                        'field' => 'area_low',
                    ])
            )
            ->add(
                (new DataColumn('area_high'))
                    ->setName($this->trans('To area', [], 'Modules.Productpricebysize.Admin'))
                    ->setOptions([
                        'field' => 'area_high',
                    ])
            )
            ->add(
                (new ActionColumn('actions'))
                    ->setOptions([
                        'actions' => (new RowActionCollection())
                            ->add(
                                (new LinkRowAction('edit'))
                                    ->setName($this->trans('Edit', [], 'Admin.Actions'))
                                    ->setIcon('edit')
                                    ->setOptions([
                                        'route' => 'productpricebysize_admin_product_ppbs_area_price_edit',
                                        'route_param_name' => 'id_area_price',
                                        'route_param_field' => 'id_area_price',
                                    ])
                            )
                            ->add(
                                (new SubmitRowAction('delete'))
                                    ->setName($this->trans('Delete', [], 'Admin.Actions'))
                                    ->setIcon('delete')
                                    ->setOptions([
                                        'method' => 'POST',
                                        'route' => 'productpricebysize_admin_product_ppbs_area_price_delete',
                                        'route_param_name' => 'id_area_price',
                                        'route_param_field' => 'id_area_price',
                                        'confirm_message' => $this->trans('Remove this Area Price?', [], 'Modules.Productpricebysize.Admin'),
                                    ])
                            ),
                    ])
            );
    }

    protected function getFilters()
    {
        if ($this->idProduct > 0) {
            $actionsTypeOptions['redirect_route_params'] = [
                'id_product' => $this->idProduct,
            ];
            $actionsTypeOptions['reset_route_params']['id_product'] = $this->idProduct;
        }

        return new FilterCollection();
    }

    private function setIdProduct(RequestStack $requestStack)
    {
        $request = $requestStack->getCurrentRequest();
        if (null !== $request && (int) $request->get('id_product') > 0) {
            $this->idProduct = $request->get('id_product');
        }
    }
}
