<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Presenter\Admin\Product;

use PrestaShop\Module\ProductPriceBySize\Repository\ProductRepository;
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductTabPresenter
{
    private $module;

    private $context;

    private $productRepository;

    public function __construct(\Module $module,
        \Context $context,
        ProductRepository $productRepository)
    {
        $this->module = $module;
        $this->context = $context;
        $this->productRepository = $productRepository;
    }

    public function present(int $idProduct): array
    {
        $presented = [];
        $presented['routePpbs'] = SymfonyContainer::getInstance()->get('router')->generate('productpricebysize_admin_product_ppbs_options', ['id_product' => $idProduct]);
        $presented['routePap'] = SymfonyContainer::getInstance()->get('router')->generate('productpricebysize_admin_product_pap_options', ['id_product' => $idProduct, 'pack_type' => 'normal']);

        $presented['routeAjax'] = SymfonyContainer::getInstance()->get('router')->generate('productpricebysize_admin_product_ppbs_product_tab_ajax');
        $presented['idProduct'] = $idProduct;

        $ppbsProduct = $this->productRepository->find($idProduct);
        if (!empty($ppbsProduct)) {
            $presented['type'] = $ppbsProduct->getType();
        } else {
            $presented['type'] = '';
        }

        return $presented;
    }
}
