<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Presenter\Admin\Vue\Component;

use PrestaShop\Module\ProductPriceBySize\Repository\DimensionRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\EquationVariableRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class EquationEditorPresenter
{
    private $module;

    private $context;

    private $dimensionRepository;

    private $equationVariableRepository;

    public function __construct(\Module $module,
        \Context $context,
        DimensionRepository $dimensionRepository,
        EquationVariableRepository $equationVariableRepository)
    {
        $this->module = $module;
        $this->context = $context;
        $this->dimensionRepository = $dimensionRepository;
        $this->equationVariableRepository = $equationVariableRepository;
    }

    public function setEquationType()
    {
    }

    public function present(): array
    {
        $presented = [];
        $dimensions = $this->dimensionRepository->getAllDimensionsByLang($this->context->language->id);
        $equationVariables = $this->equationVariableRepository->findAll();

        $presented = [
            ['name' => 'product_price'],
            ['name' => 'base_price'],
            ['name' => 'attribute_price'],
            ['name' => 'area_price'],
            ['name' => 'total_area'],
            ['name' => 'product_weight'],
            ['name' => 'quantity'],
        ];

        foreach ($equationVariables as $equationVariable) {
            $presented[] = [
                'name' => $equationVariable->getName(),
            ];
        }
        foreach ($dimensions as $dimension) {
            $presented[] = [
                'name' => $dimension['name'],
            ];
        }

        return $presented;
    }
}
