<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Presenter\Front;

if (!defined('_PS_VERSION_')) {
    exit;
}

class CartPresenter
{
    private $module;

    private $context;

    public function __construct(\Module $module, \Context $context)
    {
        $this->module = $module;
        $this->context = $context;
    }

    public function presentCustomizationString(string $customizationString, bool $html = true): string
    {
        $html = true;
        if (empty($customizationString)) {
            return '';
        }

        if ($this->context->getContext()->controller->controller_type === 'admin') {
            $html = false;
        }
        if ($html) {
            $value = '';
            $options = explode('. ', $customizationString);
            if (!empty($options)) {
                foreach ($options as $option) {
                    if (empty($option)) {
                        continue;
                    }
                    $pattern = '/^(.*?)(\s*:\s*)(.*)$/';
                    $replacement = '<strong>$1</strong>$2$3';
                    $value .= preg_replace($pattern, $replacement, $option) . '<br>';
                }
                $value = preg_replace('/<br>$/', '', $value); // remove last <br>

                return $value;
            }
        }

        return $customizationString;
    }
}
