<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Repository;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Mapping\ClassMetadata;
use PrestaShop\PrestaShop\Adapter\ContainerFinder;

if (!defined('_PS_VERSION_')) {
    exit;
}

class AreaPriceRepository extends EntityRepository
{
    private $connection;

    private $databasePrefix;

    public function __construct(EntityManagerInterface $em, ClassMetadata $class)
    {
        parent::__construct($em, $class);
        $container = (new ContainerFinder(\Context::getContext()))->getContainer();
        if ($container !== null) {
            $this->connection = $container->get('doctrine.dbal.default_connection');
        }
        $this->databasePrefix = $container->getParameter('database_prefix');
    }

    public function getByArea(int $idProduct, float $totalArea, int $idShop): array
    {
        $queryBuilder = $this->connection->createQueryBuilder();
        $queryBuilder
            ->select('*')
            ->from($this->databasePrefix . 'ppbs_area_price')
            ->where('id_product = :id_product')
            ->andWhere('id_shop = :id_shop')
            ->andWhere(':total_area >= area_low')
            ->andWhere(':total_area <= area_high')
            ->setParameter('id_shop', $idShop)
            ->setParameter('id_product', $idProduct)
            ->setParameter('total_area', $totalArea);
        // $result = $queryBuilder->execute()->fetchAssociative();
        $result = $queryBuilder->execute()->fetch();

        return (!empty($result)) ? $result : [];
    }
}
