<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Repository;

use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\EntityRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class DimensionRepository extends EntityRepository
{
    private $registry;

    private $connection;

    private $databasePrefix;

    public function getOne(int $idDimension)
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT d
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsDimension d
            WHERE d.id = :idDimension'
        )->setParameter('idDimension', $idDimension);
        $row = $query->getOneOrNullResult(AbstractQuery::HYDRATE_ARRAY);

        if (!empty($row)) {
            $query = $entityManager->createQuery(
                'SELECT dl
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsDimensionLang dl
            WHERE dl.idDimension = :idDimension'
            )->setParameter('idDimension', $idDimension);
            $resultLang = $query->getArrayResult();
            $row['lang'] = $resultLang;
        }

        return !empty($row) ? $row : [];
    }

    public function getAllDimensionsByLang(int $idLang): array
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT d, dl
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsDimension d
            INNER JOIN d.dimensionLangs dl
            WHERE dl.idLang = :idLang'
        )->setParameter('idLang', $idLang);
        $result = $query->getArrayResult();

        if (!empty($result)) {
            foreach ($result as &$row) {
                $row['lang'] = $row['dimensionLangs'][0];
                unset($row['dimensionLangs']);
            }
        }

        return $result;
    }

    public function getDimensionLang(int $idDimension, int $idLang): array
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT dl
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsDimensionLang dl
            WHERE
                dl.idDimension = :idDimension AND 
                dl.idLang = :idLang
            '
        )->setParameter('idLang', $idLang)
        ->setParameter('idDimension', $idDimension);
        $result = $query->getArrayResult();

        return $result[0] ?? [];
    }

    public function deleteDimensionLang(int $idDimension, int $idLang): bool
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'UPDATE PrestaShop\Module\ProductPriceBySize\Entity\PpbsDimensionLang dl
             SET dl.image = NULL
             WHERE dl.idDimension = :idDimension AND dl.idLang = :idLang'
        )->setParameter('idDimension', $idDimension)
            ->setParameter('idLang', $idLang);
        $query->execute();

        return true;
    }

    public function softDelete(int $idDimension): bool
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'UPDATE PrestaShop\Module\ProductPriceBySize\Entity\PpbsDimension d
             SET d.isDeleted = 1
             WHERE d.id = :idDimension'
        )->setParameter('idDimension', $idDimension);
        $query->execute();

        $query = $entityManager->createQuery(
            "UPDATE PrestaShop\Module\ProductPriceBySize\Entity\PpbsDimensionLang dl
             SET dl.image = ''
             WHERE dl.idDimension = :idDimension"
        )->setParameter('idDimension', $idDimension);
        $query->execute();

        return true;
    }
}
