<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Repository;

use Doctrine\ORM\EntityRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductFieldValueRepository extends EntityRepository
{
    private $registry;

    private $connection;

    private $databasePrefix;

    public function getNewPosition(int $idProductField): int
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT MAX(pfv.position) as maxPosition
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductFieldValue pfv
            WHERE pfv.idProductField = :idProductField'
        )->setParameter('idProductField', $idProductField);
        $result = $query->getArrayResult();

        return (int) $result[0]['maxPosition'] + 1;
    }
}
