<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Repository;

use Doctrine\ORM\EntityRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductPackRepository extends EntityRepository
{
    public function get(int $idProduct, int $idProductAttribute, bool $getDefault): array
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT pp
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductPack pp
            WHERE pp.idProduct = :idProduct
            AND pp.idProductAttribute = :idProductAttribute'
        )
            ->setParameter('idProduct', $idProduct)
            ->setParameter('idProductAttribute', $idProductAttribute);
        $row = $query->getArrayResult();

        if (empty($row) && $getDefault) {
            $query = $entityManager->createQuery(
                'SELECT pp
                FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductPack pp
                WHERE pp.idProduct = :idProduct
                AND pp.idProductAttribute = 0'
            )
                ->setParameter('idProduct', $idProduct);
            $row = $query->getArrayResult();
        }

        return !empty($row) ? $row[0] : [];
    }
}
