<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Repository;

use Doctrine\ORM\EntityRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class StockRepository extends EntityRepository
{
    public function get(int $idProduct, int $idProductAttribute, int $idShop): float
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT s
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsStock s
            WHERE s.idProduct = :idProduct
            AND s.idProductAttribute = :idProductAttribute
            AND s.idShop = :idShop'
        )
            ->setParameter('idProduct', $idProduct)
            ->setParameter('idProductAttribute', $idProductAttribute)
            ->setParameter('idShop', $idShop);
        $result = $query->getArrayResult();

        if (empty($result)) {
            return 0;
        }

        return (float) $result[0]['stock'] ?? 0;
    }

    public function getByProduct(int $idProduct, int $idShop): array
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT s
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsStock s
            WHERE s.idProduct = :idProduct
            AND s.idShop = :idShop'
        )
            ->setParameter('idProduct', $idProduct)
            ->setParameter('idShop', $idShop);

        return $query->getArrayResult();
    }
}
