<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Repository;

use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\EntityRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class UnitRepository extends EntityRepository
{
    public function getOne(int $idUnit)
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT u
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsUnit u
            WHERE u.id = :idUnit'
        )->setParameter('idUnit', $idUnit);
        $row = $query->getOneOrNullResult(AbstractQuery::HYDRATE_ARRAY);

        if (!empty($row)) {
            $query = $entityManager->createQuery(
                'SELECT ul
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsUnitLang ul
            WHERE ul.idUnit = :idUnit'
            )->setParameter('idUnit', $idUnit);
            $resultLang = $query->getArrayResult();
            $row['lang'] = $resultLang;
        }

        return !empty($row) ? $row : [];
    }

    public function findAllByLang(int $idLang): array
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT u, ul
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsUnit u
            INNER JOIN u.langs ul
            WHERE ul.idLang = :idLang'
        )->setParameter('idLang', $idLang);

        return $query->getArrayResult();
    }

    public function findByLang(int $idUnit, int $idLang): array
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'SELECT u, ul
            FROM PrestaShop\Module\ProductPriceBySize\Entity\PpbsUnit u
            INNER JOIN u.langs ul
            WHERE ul.idLang = :idLang
            AND u.id = :idUnit'
        )
            ->setParameter('idLang', $idLang)
            ->setParameter('idUnit', $idUnit);
        $row = $query->getArrayResult();
        if (!empty($row)) {
            $row[0]['lang'] = $row[0]['langs'][0];
        }

        return !empty($row) ? $row[0] : [];
    }

    public function softDelete(int $idUnit): bool
    {
        $entityManager = $this->getEntityManager();
        $query = $entityManager->createQuery(
            'UPDATE PrestaShop\Module\ProductPriceBySize\Entity\PpbsUnit u
             SET u.isDeleted = 1
             WHERE u.id = :idUnit'
        )->setParameter('idUnit', $idUnit);
        $query->execute();

        return true;
    }
}
