<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Repository;

use Doctrine\ORM\EntityRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class WastageRepository extends EntityRepository
{
    public function delete(int $idWastage): bool
    {
        $queryBuilder = $this->getEntityManager()->createQueryBuilder();
        $queryBuilder
            ->delete('PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductWastage', 'pw')
            ->where('pw.idWastage = :idWastage')
            ->setParameter('idWastage', $idWastage);
        $queryBuilder->getQuery()->execute();

        $queryBuilder = $this->createQueryBuilder('w');
        $queryBuilder
            ->delete()
            ->where('w.id = :id')
            ->setParameter('id', $idWastage);
        $queryBuilder->getQuery()->execute();

        return true;
    }
}
