<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service\Admin;

use Doctrine\ORM\EntityManagerInterface;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsAreaPrice;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProduct;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductEquation;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductField;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductFieldValue;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductFieldValueLang;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductPack;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductUnit;
use PrestaShop\Module\ProductPriceBySize\Entity\PpbsProductWastage;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductEquationRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductFieldRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductPackRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class MassAssignService
{
    public $productRepository;

    protected $productFieldRepository;

    protected $entityManager;

    protected $productEquationRepository;

    protected $productPackRepository;

    public function __construct(
        EntityManagerInterface $entityManager,
        ProductRepository $productRepository,
        ProductFieldRepository $productFieldRepository,
        ProductEquationRepository $productEquationRepository,
        ProductPackRepository $productPackRepository) {
        $this->productRepository = $productRepository;
        $this->productFieldRepository = $productFieldRepository;
        $this->productEquationRepository = $productEquationRepository;
        $this->productPackRepository = $productPackRepository;
        $this->entityManager = $entityManager;
    }

    public function duplicateProduct(int $idProductSource, int $idProductDestination): bool
    {
        $product = $this->productRepository->find($idProductSource);

        if (empty($product)) {
            return false;
        }

        $productDestination = new PpbsProduct();
        $productDestination->setId($idProductDestination);
        $productDestination->setIsEnabled($product->getIsEnabled());
        $productDestination->setUnit($product->getUnit());
        $productDestination->setIsFrontConversionEnabled($product->getIsFrontConversionEnabled());
        $productDestination->setFrontConversionOperator($product->getFrontConversionOperator());
        $productDestination->setFrontConversionValue($product->getFrontConversionValue());
        $productDestination->setMinTotalArea($product->getMinTotalArea());
        $productDestination->setMinPrice($product->getMinPrice());
        $productDestination->setSetupFee($product->getSetupFee());
        $productDestination->setType($product->getType());
        $productDestination->setPapType($product->getPapType());
        $productDestination->setIsDynamicPrice($product->getIsDynamicPrice());
        $productDestination->setIsAttributePriceAreaPrice($product->getIsAttributePriceAreaPrice());
        $productDestination->setIsStockEnabled($product->getIsStockEnabled());

        $this->entityManager->persist($productDestination);
        $this->entityManager->flush();

        foreach ($product->getProductFields() as $productField) {
            $productFieldNew = new PpbsProductField();
            $productFieldNew->setProduct($productDestination);
            $productFieldNew->setDimension($productField->getDimension());
            $productFieldNew->setFieldType($productField->getFieldType());
            $productFieldNew->setUnit($productField->getUnit());
            $productFieldNew->setMin($productField->getMin());
            $productFieldNew->setMax($productField->getMax());
            $productFieldNew->setDefaultValue($productField->getDefaultValue());
            $productFieldNew->setStep($productField->getStep());
            $productFieldNew->setRatio($productField->getRatio());
            $productFieldNew->setDecimals($productField->getDecimals());
            $productFieldNew->setPosition($productField->getPosition());
            $this->entityManager->persist($productFieldNew);
            $this->entityManager->flush();

            $productFieldValues = $productField->getValues();
            foreach ($productFieldValues as $productFieldValue) {
                $productFieldValueNew = new PpbsProductFieldValue();
                $productFieldValueNew->setProductField($productFieldNew);
                $productFieldValueNew->setValue($productFieldValue->getValue());
                $productFieldValueNew->setPosition($productFieldValue->getPosition());
                $productFieldValueNew->setLangs($productFieldValue->getLangs());
                $this->entityManager->persist($productFieldValueNew);

                foreach ($productFieldValue->getLangs() as $productFieldValueLang) {
                    $productFieldValueLangNew = new PpbsProductFieldValueLang();
                    $productFieldValueLangNew->setProductFieldValue($productFieldValueNew);
                    $productFieldValueLangNew->setIdLang($productFieldValueLang->getIdLang());
                    $productFieldValueLangNew->setText($productFieldValueLang->getText());
                    $this->entityManager->persist($productFieldValueLangNew);
                }
            }
            $this->entityManager->flush();
        }

        $productEquations = $this->productEquationRepository->findBy([
            'idProduct' => $idProductSource,
            'idProductAttribute' => 0,
        ]);

        foreach ($productEquations as $productEquation) {
            $productEquationNew = new PpbsProductEquation();
            $productEquationNew->setProduct($productDestination);
            $productEquationNew->setIdProductAttribute(0);
            $productEquationNew->setEquationTemplate($productEquation->getEquationTemplate());
            $this->entityManager->persist($productEquationNew);
        }
        $this->entityManager->flush();

        $productPack = $this->productPackRepository->findOneBy([
            'idProduct' => $idProductSource,
            'idProductAttribute' => 0,
        ]);

        if (!empty($productPack)) {
            $productPackNew = new PpbsProductPack();
            $productPackNew->setProduct($productDestination);
            $productPackNew->setIdProductAttribute(0);
            $productPackNew->setPackArea($productPack->getPackArea());
            $productPackNew->setAreaPrice($productPack->getAreaPrice());
            $productPackNew->setRollHeight($productPack->getRollHeight());
            $productPackNew->setRollWidth($productPack->getRollWidth());
            $productPackNew->setPatternRepeat($productPack->getPatternRepeat());
            $productPackNew->setCoverage($productPack->getCoverage());
            $this->entityManager->persist($productPackNew);
            $this->entityManager->flush();
        }

        $productUnits = $product->getProductUnits();

        foreach ($productUnits as $productUnit) {
            $productUnitNew = new PpbsProductUnit();
            $productUnitNew->setProduct($productDestination);
            $productUnitNew->setUnit($productUnit->getUnit());
            $productUnitNew->setIsDefault($productUnit->getIsDefault());
            $this->entityManager->persist($productUnitNew);
        }
        $this->entityManager->flush();

        $productWastage = $product->getWastageOptions();
        foreach ($productWastage as $wastage) {
            $wastageNew = new PpbsProductWastage();
            $wastageNew->setidProduct($idProductDestination);
            $wastageNew->setIdWastage($wastage->getIdWastage());
            $wastageNew->setProduct($productDestination);
            $wastageNew->setWastage($wastage->getWastage());
            $this->entityManager->persist($wastageNew);
        }
        $this->entityManager->flush();

        $productAreaPrices = $product->getAreaPrices();
        foreach ($productAreaPrices as $areaPrice) {
            $areaPriceNew = new PpbsAreaPrice();
            $areaPriceNew->setidProduct($idProductDestination);
            $areaPriceNew->setIdShop($areaPrice->getIdShop());
            $areaPriceNew->setProduct($productDestination);
            $areaPriceNew->setAreaLow($areaPrice->getAreaLow());
            $areaPriceNew->setAreaHigh($areaPrice->getAreaHigh());
            $areaPriceNew->setPrice($areaPrice->getPrice());
            $areaPriceNew->setImpact($areaPrice->getImpact());
            $areaPriceNew->setWeight($areaPrice->getWeight());
            $this->entityManager->persist($areaPriceNew);
        }
        $this->entityManager->flush();

        $this->productRepository->setCustomizationFieldModuleFlag($idProductDestination);
        
        return true;
    }

    public function setCustomizationFieldModuleFlag(int $idProduct): void
    {
        $this->productRepository->setCustomizationFieldModuleFlag($idProduct);
    }
}
