<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service\Admin;

use Doctrine\ORM\EntityManagerInterface;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductFieldRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductDeleteService
{
    protected $productRepository;

    protected $productFieldRepository;

    protected $entityManager;

    public function __construct(
        EntityManagerInterface $entityManager,
        ProductRepository $productRepository,
        ProductFieldRepository $productFieldRepository) {
        $this->productRepository = $productRepository;
        $this->productFieldRepository = $productFieldRepository;
        $this->entityManager = $entityManager;
    }

    public function deleteProductField(int $idProductField): array
    {
        $productField = $this->productFieldRepository->find($idProductField);
        if (!empty($productField)) {
            $productFieldValues = $productField->getValues();
            foreach ($productFieldValues as $productFieldValue) {
                foreach ($productFieldValue->getLangs() as $lang) {
                    $this->entityManager->remove($lang);
                }
                $this->entityManager->remove($productFieldValue);
            }
        }
        $this->entityManager->remove($productField);
        $this->entityManager->flush();

        return [
            'idProduct' => $productField->getIdProduct(),
        ];
    }

    public function deleteSettings(int $idProduct): void
    {
        $product = $this->productRepository->find($idProduct);
        if (empty($product)) {
            return;
        }

        foreach ($product->getProductFields() as $productField) {
            $this->deleteProductField($productField->getId());
        }
        $this->productRepository->deleteProductUnits($idProduct);
        $this->productRepository->deleteProductWastage($idProduct);
        $this->productRepository->deleteProductEquations($idProduct);
        $this->productRepository->deleteProductAreaPrices($idProduct);
        $this->productRepository->deleteProductData($idProduct);
        $this->productRepository->deleteProductPackData($idProduct);
    }
}
