<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service;

if (!defined('_PS_VERSION_')) {
    exit;
}

class AssetsService
{
    public static function getImagesPath(): string
    {
        return _PS_MODULE_DIR_ . 'productpricebysize/uploads/';
    }

    public static function getThumbnailImagesPath(): string
    {
        return self::getImagesPath() . 'small/';
    }

    public static function getLargeImagesPath(): string
    {
        return self::getImagesPath() . 'large/';
    }

    public static function getImagesUrl(): string
    {
        $link = new \Link();

        return $link->getBaseLink() . 'modules/productpricebysize/uploads/';
    }
}
