<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service;

if (!defined('_PS_VERSION_')) {
    exit;
}

class BridgeService
{
    public static function getPcoPriceImpact(\Context $context, ?array $params, bool $useTax): float
    {
        if (empty($params)) {
            return 0;
        }
        if (\Module::isEnabled('productcustomoptions')) {
            if (\PrestaShop\Module\ProductCustomOptions\Repository\ProductRepository::isPcoProduct((int) $params['id_product'])) {
                $params['use_tax'] = 0; // Ppbs wil add taxes
                $pcoPriceService = new \PrestaShop\Module\ProductCustomOptions\Service\PriceService($context);

                return $pcoPriceService->priceCalculation($params, true, [], true, true);
            }
        }

        return 0;
    }
}
