<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service\Common;

if (!defined('_PS_VERSION_')) {
    exit;
}

class AbstractCartService
{
    protected $context;

    protected $moduleInstance;

    protected $productRepository;

    protected $equationRepository;

    protected $equationService;

    protected $cartRepository;

    public function __construct(\Context $context, \Module $moduleInstance)
    {
        $this->context = $context;
        $this->moduleInstance = $moduleInstance;
        $this->cartRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.cart_repository');
        $this->productRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.product_repository');
        $this->equationService = $this->moduleInstance->get('prestashop.module.productpricebysize.factory.equation_service');
        $this->equationRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.equation_repository');
    }

    protected function getIdProductAttributeFromGroup(int $idProduct, $group, int $ipa): int
    {
        if (\Tools::getValue('group') != '') {
            $idProductAttribute = \Product::getIdProductAttributeByIdAttributes($idProduct, $group);
        } else {
            $idProductAttribute = 0;
        }
        if ((int) $idProductAttribute == 0 && $ipa > 0) {
            $idProductAttribute = $ipa;
        }

        // This can happen when a product is being added from a module like the homepage carousel
        if ((int) $idProductAttribute == 0) {
            $idProductAttribute = \Product::getDefaultAttribute($idProduct);
        }

        return $idProductAttribute;
    }

    protected function checkAndCreateCart(): void
    {
        if (!$this->context->cart->id) {
            if (\Context::getContext()->cookie->id_guest) {
                $guest = new \Guest(\Context::getContext()->cookie->id_guest);
                $this->context->cart->mobile_theme = $guest->mobile_theme;
            }
            $this->context->cart->add();
            if ($this->context->cart->id) {
                $this->context->cookie->id_cart = (int) $this->context->cart->id;
            }
        }
    }
}
