<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service;

if (!defined('_PS_VERSION_')) {
    exit;
}

class EquationService
{
    private $context;

    private $moduleInstance;

    private $dimensionRepository;

    public function __construct(\Context $context, \Module $moduleInstance)
    {
        $this->context = $context;
        $this->moduleInstance = $moduleInstance;
        $this->dimensionRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.dimension_repository');
    }

    public function populateMathParams(array &$mathParams, array $cartData, int $idProduct, int $idProductAttribute, int $idCustomization, int $idCart)
    {
        foreach ($cartData as $cartDataTemp) {
            foreach ($cartDataTemp['productFields']['fields'] as $productField) {
                $dimension = $this->dimensionRepository->getOne((int) $productField['dimension']['id']);
                $mathParams[$dimension['name']] = (float) FormatterService::removeNumberFormatting($productField['value']);
            }
        }
    }
}
