<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;

class FormatterService
{
    protected $context;

    public function __construct(\Context $context)
    {
        $this->context = $context;
    }

    private static function doEncoding($matches)
    {
        return mb_convert_encoding(pack('H*', $matches[1]), 'UTF-8', 'UTF-16');
    }

    public static function rawJsonEncode($input): string
    {
        return preg_replace_callback(
            '/\\\\u([0-9a-zA-Z]{4})/',
            ['self', 'doEncoding'],
            json_encode($input)
        );
    }

    public static function formatCustomizationText(string $text): string
    {
        $optionsString = '';
        $options_array = explode(' | ', $text);
        if (is_array($options_array)) {
            foreach ($options_array as $option) {
                $pattern = '/^([^:]+)\\s*:/';
                $replacement = '<b>$1</b>:';
                $options_text_formatted = preg_replace($pattern, $replacement, $option);
                $optionsString .= $options_text_formatted . '<br>';
            }
        }

        return $optionsString;
    }

    public static function removeNumberFormatting(string $number): string
    {
        if (substr_count($number, ',') == 1) {
            return str_replace(',', '.', $number);
        }

        return $number;
    }

    private static function getPricePrecision(): int
    {
        if ((int) _PS_PRICE_COMPUTE_PRECISION_ == 0 || !defined(_PS_PRICE_COMPUTE_PRECISION_)) {
            return 2;
        } else {
            return _PS_PRICE_COMPUTE_PRECISION_;
        }
    }

    public static function formatPrice(float $price): string
    {
        $priceRounded = \Tools::ps_round($price, self::getPricePrecision());
        $priceFormatter = new PriceFormatter();

        return $priceFormatter->format($priceRounded);
    }
}
