<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service;

use PrestaShop\PrestaShop\Core\Image\Uploader\Exception\UploadedImageConstraintException;
use Symfony\Component\HttpFoundation\File\UploadedFile;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ImageUploaderService
{
    protected $context;

    public function __construct(\Context $context)
    {
        $this->context = $context;
    }

    public static function getUrlToImages(string $imageSize): string
    {
        $link = new \Link();
        if ($imageSize == 'small') {
            return $link->getBaseLink() . 'modules/productpricebysize/uploads/small/';
        } else {
            return $link->getBaseLink() . 'modules/productpricebysize/uploads/large/';
        }
    }

    public function deleteImage(string $imageFilename)
    {
        if (file_exists(AssetsService::getThumbnailImagesPath() . $imageFilename)) {
            unlink(AssetsService::getThumbnailImagesPath() . $imageFilename);
        }
        if (file_exists(AssetsService::getLargeImagesPath() . $imageFilename)) {
            unlink(AssetsService::getLargeImagesPath() . $imageFilename);
        }
    }

    public function upload(UploadedFile $image, string $fileNamePrefix): array
    {
        $imageTypeLarge = \ImageType::getByNameNType(\ImageType::getFormattedName('large'), 'products');
        $imageTypeThumbnail = \ImageType::getByNameNType(\ImageType::getFormattedName('home'), 'products');

        if (!\ImageManager::isRealImage($image->getPathname(), $image->getClientMimeType())
            || !\ImageManager::isCorrectImageFileExt($image->getClientOriginalName())
            || preg_match('/\%00/', $image->getClientOriginalName()) // prevent null byte injection
        ) {
            throw new UploadedImageConstraintException(sprintf('Image format "%s", not recognized, allowed formats are: .gif, .jpg, .png', $image->getClientOriginalExtension()), UploadedImageConstraintException::UNRECOGNIZED_FORMAT);
        }

        $extension = $image->getClientOriginalExtension();
        $rand = rand(0, 9999);
        $filename = $fileNamePrefix . '_' . sprintf('%04d', $rand) . '.' . $extension;
        // \ImageManager::resize($image->getPathname(), AssetsService::getImagesPath() . 'large/' . $filename, $imageTypeLarge['width'], $imageTypeLarge['height']);
        copy($image->getPathname(), AssetsService::getImagesPath() . 'large/' . $filename);
        \ImageManager::resize($image->getPathname(), AssetsService::getImagesPath() . 'small/' . $filename, $imageTypeThumbnail['width'], $imageTypeThumbnail['height']);

        return [
            'filename' => $filename,
        ];
    }
}
