<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service;

use Doctrine\ORM\EntityManagerInterface;
use PrestaShop\Module\ProductPriceBySize\Repository\DimensionRepository;
use PrestaShop\Module\ProductPriceBySize\Repository\UnitRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

class InstallService
{
    protected $entityManager;

    protected $dimensionRepository;

    protected $unitRepository;

    public function __construct(
        EntityManagerInterface $entityManager,
        DimensionRepository $dimensionRepository,
        UnitRepository $unitRepository) {
        $this->dimensionRepository = $dimensionRepository;
        $this->unitRepository = $unitRepository;
        $this->entityManager = $entityManager;
    }

    public function test()
    {
        error_log('test');
    }
}
