<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service\Pap;

use PrestaShop\Module\ProductPriceBySize\Service\Common\AbstractPriceService;
use PrestaShop\Module\ProductPriceBySize\Service\Common\PriceServiceInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

class PriceService extends AbstractPriceService implements PriceServiceInterface
{
    public function priceCalculation(array $params, ?\Customer $customer, bool $isCustomizationLine, bool $useCache): float
    {
        $idProduct = (int) $params['id_product'];
        $idProductAttribute = (int) $params['id_product_attribute'];
        $productRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.product_repository');
        $productPackRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.product_pack_repository');
        $ppbsProduct = $productRepository->find($idProduct);
        $productPack = $productPackRepository->get($idProduct, $idProductAttribute, true);

        if (empty($productPack) || empty($ppbsProduct) || !$ppbsProduct->getIsDynamicPrice() || $productPack['packArea'] == 0) {
            return (float) $params['price'];
        }

        $cartData = $this->cartRepository->getCartData((int) $params['id_product'], (int) $params['id_cart'], (int) $params['id_product_attribute'], (int) $this->context->shop->id, (int) $params['id_customization']);

        if (empty($cartData[0]['productFields'])) {
            return (float) $params['price'];
        }

        $cacheId = 'PapPriceService::priceCalculation_' . $params['id_product'] . '-' . $params['id_product_attribute'] . '-' . $params['id_customization'] . '-' . $params['id_cart'] . '-' . (int) $params['use_tax'];
        if ($useCache) {
            if (\Cache::isStored($cacheId)) {
                return \Tools::ps_round(\Cache::retrieve($cacheId), 6);
            }
        }

        $totalAreaInBoxes = $params['quantity'] * $productPack['packArea'];
        $price = ($totalAreaInBoxes * $params['price']) / $params['quantity'];
        \Cache::store($cacheId, $price);

        return $price / $params['quantity'];
    }
}
