<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Service;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductService
{
    private $context;

    public function __construct(\Context $context)
    {
        $this->context = $context;
    }

    public function getCoverImage(int $idProduct): string
    {
        $parentProductObj = new \Product($idProduct, false, \Context::getContext()->language->id);
        $coverImage = $parentProductObj->getCover($parentProductObj->id);
        $productImage = \Context::getContext()->link->getImageLink($parentProductObj->link_rewrite, $coverImage['id_image'], \ImageType::getFormattedName('home'));

        return $productImage;
    }

    public function getAttributes(int $idProduct): array
    {
        $productObj = new \Product($idProduct, true, $this->context->language->id, $this->context->shop->id);
        $attributesGroups = $productObj->getAttributesGroups($this->context->language->id);
        $images = $productObj->getCombinationImages($this->context->language->id);
        $groups = [];

        foreach ($attributesGroups as $attributeGroup) {
            $ipa = $attributeGroup['id_product_attribute'];
            $groups[$ipa]['id_product_attribute'] = $ipa;
            if (!isset($groups[$ipa]['label'])) {
                $groups[$ipa]['label'] = $attributeGroup['public_group_name'] . ' : ' . $attributeGroup['attribute_name'] . ', ';
            } else {
                $groups[$ipa]['label'] .= $attributeGroup['public_group_name'] . ' : ' . $attributeGroup['attribute_name'] . ', ';
            }
            if (isset($images[$ipa])) {
                $combination_img = $images[$ipa][0]['id_image'];
                $groups[$ipa]['url_image'] = $this->context->link->getImageLink($productObj->link_rewrite, $combination_img, \ImageType::getFormattedName('medium'));
            } else {
                $groups[$ipa]['url_image'] = $this->getCoverImage($idProduct);
            }
        }

        return $groups;
    }

    public static function getParentProductInfo(int $idProduct): array
    {
        $parentProductObj = new \Product($idProduct, false, \Context::getContext()->language->id);
        $coverImage = $parentProductObj->getCover($parentProductObj->id);
        $productImage = '';

        if ($coverImage) {
            $productImage = \Context::getContext()->link->getImageLink($parentProductObj->link_rewrite, $coverImage['id_image'], \ImageType::getFormattedName('home'));
        }

        $parentProduct['name'] = $parentProductObj->name;
        $parentProduct['id_product'] = $parentProductObj->id;
        $parentProduct['image'] = $productImage;

        return $parentProduct;
    }
}
