import ProductSearch from '../vue/components/productSearch.js';

const {createApp, ref, onMounted, watch} = Vue

const app = createApp({
    components: {
        'ppbs_product_search': ProductSearch,
    },

    delimiters: ['[[', ']]'],
    setup() {
        const selected = ref(0);
        const searchResults = ref([]);
        const selectedProducts = ref([]);

        const getProductList = (selectedCategories) => {

            if (selectedCategories.length > 1) {
                searchResults.value = [];
                return;
            }

            $.ajax({
                url: window.productpricebysize.routes.productpricebysize_admin_ajax,
                type: 'POST',
                data: {
                    'id_category': selectedCategories[0],
                    'selectedCategories': selectedCategories
                },
                success: function (response) {
                    searchResults.value = response;
                },
                error: function (jqXHR, textStatus, errorThrown) {}
            });
        }

        const onCategorySelected = () => {
            let selectedCategories = [];
            $('input[name="form[massassign_categories][]"]').each(function () {
                if ($(this).is(':checked')) {
                    selectedCategories.push($(this).val());
                }
            });
            getProductList(selectedCategories);
        };

        onMounted(() => {
            let self = this;
            $("body").on("change", 'input[name="form[massassign_categories][]"]', function () {
                onCategorySelected();
                return false;
            });
        });

        watch(selectedProducts, (newVal, oldVal) => {
            $("#form_id_product_list").val(JSON.stringify(newVal));
        });

        return {
            selected,
            searchResults,
            selectedProducts
        }
    }
})

const vm = app.mount('#ppbs-mass-assign');
