const {createApp, ref, onMounted, watch} = Vue

const app = createApp({
    delimiters: ['[[', ']]'],

    setup() {

        const getData = () => {
            let data = [];
            document.querySelectorAll('.stock').forEach(input => {
                let idProductAttribute = input.getAttribute('data-id_product_attribute');
                data.push({
                    id_product_attribute: idProductAttribute,
                    stock: input.value
                });
            });
            return data;
        };

        const handleStockChange = (event) => {
            document.getElementById('form_data').value = JSON.stringify(getData());
        };

        onMounted(() => {
            handleStockChange(null);
            document.querySelectorAll('.stock').forEach(input => {
                input.addEventListener('change', handleStockChange);
            })
        });

        return {
        };
    },
})

const vm = app.mount('#ppbs-product-stock');

