import EquationEditor from '../vue/components/equationEditor.js';

const {createApp, ref, onMounted, watch} = Vue

const app = createApp({
    components: {
        'ppbs_equation_editor': EquationEditor,
    },

    delimiters: ['[[', ']]'],

    setup() {
        const selectedOption = ref('');
        const templateName = ref('');
        const equationTemplates = ref([]);
        const saveMethod = ref('');
        const equation = ref('');
        const selectedIdEquationTemplate = ref('');
        const showSaveAsTemplate = ref(false);

        const handleRadioChange = (event) => {
            if (event.target.value === 'template') {
                selectedOption.value = 1;
            } else {
                selectedOption.value = 0;
            }
        };

        const saveClick = (event) => {
            if (saveMethod.value === 'template') {
                document.getElementById('form_id_equation_template').value = selectedIdEquationTemplate.value
            }
            $(".col-form").find('form').submit();
        };

        const SaveTemplateClick = (event) => {
            document.getElementById('form_id_equation_template').value = '0';
            document.getElementById('form_is_global').value = '1';
            document.getElementById('form_name').value = templateName.value;
            document.getElementById('form_save_method').value = 'template';
            $(".col-form").find('form').submit();
        };

        const saveAsTemplateLinkClick = (event) => {
            showSaveAsTemplate.value = !showSaveAsTemplate.value;
            console.log(showSaveAsTemplate.value);
        }

        watch(selectedOption, (newValue, oldValue) => {
            document.getElementById('form_is_global').value = newValue;
        });

        watch(selectedIdEquationTemplate, (newValue, oldValue) => {
            //document.getElementById('form_id_equation_template').value = newValue;
        });

        watch(saveMethod, (newValue, oldValue) => {
            document.getElementById('form_save_method').value = newValue;
        });

        onMounted(() => {
            equationTemplates.value = window.initialState.equationTemplates;
            if (window.initialState.isGlobal === '1') {
                saveMethod.value = 'template';
                selectedIdEquationTemplate.value = window.initialState.formData.id_equation_template;
            } else {
                saveMethod.value = 'custom';
            }
        });

        return {
            selectedOption,
            equationTemplates,
            templateName,
            saveMethod,
            equation,
            selectedIdEquationTemplate,
            showSaveAsTemplate,
            handleRadioChange,
            saveClick,
            saveAsTemplateLinkClick,
            SaveTemplateClick,
        };
    },
})

const vm = app.mount('#app');

