const {createApp, ref, onMounted, watch} = Vue

const app = createApp({
    delimiters: ['[[', ']]'],


    setup() {

        const productType = ref('');

        const onClearProductSettingsClick = (event) => {
            fetch(window.productPriceBySize.routeAjax, {
                method: 'POST', // HTTP method
                headers: {
                    'Content-Type': 'application/json', // Specify the request payload format
                },
                body: JSON.stringify({
                    'action': 'clearProductSettings',
                    'idProduct': window.productPriceBySize.idProduct,
                })
            })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(data => {
                    productType.value = '';
                })
                .catch(error => {
                    console.error('Error:', error);
                });
        };

        onMounted(() => {
            productType.value = window.productPriceBySize.type;
        });

        return {
            productType,
            onClearProductSettingsClick
        };
    },
})

const vm = app.mount('#ppbs-app');
