export default {
    props: {
        variables: {
            type: Array,
            required: true
        },

        form_field_equation_id: {
            type: String,
            required: true
        },

        modelValue: {
            type: String,
            required: true
        }
    },
    template: `
        <div class="ppbs-component-equation-editor">
            <textarea ref="display" @keyup="textAreaChange()" style="width:100%" placeholder="0" spellcheck="false"></textarea>
            <div class="buttons-wrapper">
                <div>
                    <div class="numbers">
                        <button class="small" @click="click(7, false)">7</button>                    
                        <button class="small" @click="click(8, false)">8</button>
                        <button class="small" @click="click(9, false)">9</button>
                        <button class="small" @click="click(4, false)">4</button>                    
                        <button class="small" @click="click(5, false)">5</button>
                        <button class="small" @click="click(6, false)">6</button>
                        <button class="small" @click="click(4, false)">1</button>                    
                        <button class="small" @click="click(5, false)">2</button>
                        <button class="small" @click="click(6, false)">3</button>
                        <button class="small" @click="click(0, false)">0</button>
                        <button class="small" @click="click('.', false)">.</button>                        
                    </div>
                    
                    <div class="variables">
                        <div v-for="(variable) in variables" :key="variable.name">
                            <button @click="click(variable.name, true)">{{ variable.name }}</button>
                        </div>
                    </div>
                </div>           
                <div class="operators">
                    <button class="small" @click="click('(', false)">(</button>
                    <button class="small" @click="click(')', false)">)</button>                
                    <button class="small" @click="click('+', false)">+</button>
                    <button class="small" @click="click('-', false)">-</button>
                    <button class="small" @click="click('/', false)">/</button>
                    <button class="small" @click="click('*', false)">*</button>
                </div>
            </div> 
        </div>
    `,
    mounted() {
        // Set the initial content of the textarea from the modelValue
        this.equation = document.getElementById(this.form_field_equation_id).value;
        this.$refs.display.value = this.equation;
    },
    watch: {
        /*modelValue: {
            handler(newVal) {
                this.equation = newVal.equation || '';
                this.$refs.display.value = this.equation;
            },
            deep: true,
            immediate: false
        }*/
        modelValue: {
            handler(newVal) {
                this.equation = newVal || '';
                this.$refs.display.value = this.equation;
                document.getElementById(this.form_field_equation_id).value = this.equation;
            },
            deep: true,
            immediate: false
        }
    },
    data() {
        return {
            equation: '',
            formFieldEquationId: '',
        };
    },
    methods: {

        textAreaChange() {
            const textarea = this.$refs.display;
            this.$emit('update:modelValue', textarea.value);
        },

        click(printValue, isVariable) {
            if (isVariable) {
                printValue = "[" + printValue + "]";
            } else {
                printValue = printValue.toString();
            }

            const textarea = this.$refs.display;
            const {selectionStart: start, selectionEnd: end, value: text} = textarea;
            textarea.value = text.slice(0, start) + printValue + text.slice(end);
            textarea.selectionStart = textarea.selectionEnd = start + printValue.length;
            textarea.focus();

            /*this.$emit('update:modelValue', {
                'equation': textarea.value,
                'form_field_equation_id': this.form_field_equation_id
            });*/
            this.$emit('update:modelValue', textarea.value);
        }

    }
};