export default {
    props: {
        form_field_id: {
            type: String,
            required: true
        },

        modelValue: {
            type: Number,
            required: true
        }
    },
    template: `
        <div class="ppbs-component-product-search">
            <input type="text" class="form-control" @keyup="onkeyUp" v-model="inputValue" placeholder="Search for a product here"  />
            <div class="search-results" v-if="searchResults.length > 0">
                <ul>
                    <li v-for="result in searchResults" :key="result.productId">
                        <a href="#" @click="selectResult(result)">{{ result.name }}</a>
                    </li>
                </ul>
            </div>
        </div>
    `,
    mounted() {
    },
    watch: {
    },
    data() {
        return {
            inputValue: '',
            searchResults: []
        };
    },
    methods: {
        selectResult(result) {
            this.inputValue = result.name;
            document.getElementById(this.form_field_id).value = result.productId;
            this.searchResults = [];
            this.$emit('update:modelValue', result.productId);
        },

        performSearch(search_phrase) {
            if (search_phrase.length < 3) {
                this.searchResults = [];
                return;
            }

            let url = window.productpricebysize.routes.admin_orders_products_search;
            let getParams = {
                search_phrase: search_phrase,
                currency_id: "1"
            };
            $.get(url, getParams
            ).then((data) => {
                this.searchResults = data.products;
            });
        },

        onkeyUp(event) {
            this.performSearch(this.inputValue);
        }
    }
};