class FrontProductController {
    quickView = false;

    getProductID() {
        let idProduct = 0;
        if (this.quickView) {
            idProduct = $(".modal").find("input[name='id_product']").val();
        } else {
            idProduct = $("form#add-to-cart-or-refresh input[name='id_product']").val();
        }
        return idProduct;
    };

    getQuantity() {
        if ($("#quantity_wanted").length > 0) {
            return parseFloat($("#quantity_wanted").val());
        } else {
            return 1;
        }
    };

    createDataField(name) {
        var hiddenInput = $('<input>', {
            type: 'hidden',
            class: 'data-field',
            id: name,
            name: name,
            value: ''
        });
        $(this.dom.form).first().append(hiddenInput);
    };

    getData() {
        let data = $(this.dom.form).find('.data-field').val();
        if (data === '') {
            return '';
        }
        return JSON.parse($(this.dom.form).find('.data-field').val());
    }

    getActiveUnit() {
        if ($(this.dom.widget.divUnitSelector).length > 0) {
            return $(this.dom.widget.divUnitSelector).find('.unit-button.selected').attr('data-name');
        }
    }

    convertToProductUnit(originalValue) {
        let newValue = originalValue;
        if (this.getActiveUnit() !== prestashop.productPriceBySize.unit.name) {
            newValue = this.unitConversion(this.getActiveUnit(), prestashop.productPriceBySize.unit.name, originalValue);
        }
        return newValue;
    }

    getTotalArea(applyConversion) {
        let data = this.getData();
        if (data === '') {
            return 0;
        }

        let totalArea = 1;
        for (let i = 0; i <= data.fields.length - 1; i++) {
            let field = data.fields[i];
            let value = field.valueNumeric;
            if (isNaN(value)) {
                value = 0;
            }
            if (applyConversion) {
                value = this.convertToProductUnit(value);
            }
            totalArea = parseFloat(totalArea) * parseFloat(value);
            totalArea = parseFloat(totalArea.toPrecision(12));
        }
        if (isNaN(totalArea)) {
            totalArea = 0;
        }
        return totalArea;
    }

    async getProductInfo() {
        let query = $("#add-to-cart-or-refresh").serialize();
        let url = MpTools.joinUrl(prestashop.productPriceBySize.urlAjax, 'action=getProductInfo&' + query);

        // Await the completion of the AJAX request
        const response = await $.ajax({
            type: 'POST',
            url: url,
            async: true, // This can be omitted as it's default
            cache: false,
            data: {
                'id_product': this.getProductID(),
                'id_shop': prestashop.productPriceBySize.idShop,
                'quantity': this.getQuantity()
            },
            dataType: 'json'
        });
        return response;
    }

    updateData() {
        let self = this;
        let optionData = {
            idProduct: this.getProductID(),
            fields: []
        };
        $('.product-field-wrapper').each(function () {
            let productField = $(this).find('.product-field');
            let value = $(productField).val();
            let optionDataItem = {
                idProductField: $(productField).attr('data-id'),
                dimensionName: $(this).attr('data-dimensionName'),
                value: value,
                valueNumeric: self.removeFormatting(value)
            };
            optionData['fields'].push(optionDataItem);
        });
        $(this.dom.widget.inputData).val(JSON.stringify(optionData));
    }

    unitConversion(unitFrom, unitTo, value) {

        if (typeof(unitFrom) === 'undefined' || typeof(unitTo) === 'undefined') {
            return value;
        }

        unitFrom = prestashop.productPriceBySize.units[unitFrom];
        unitTo = prestashop.productPriceBySize.units[unitTo];
        let baseValue = value * unitFrom['conversionFactor'];  // value in mm
        return baseValue / unitTo['conversionFactor'];
    };

    addTax(priceExTax) {
        priceExTax = parseFloat(priceExTax);
        if (prestashop.productPriceBySize.productInfo.price_display == 0 || prestashop.productPriceBySize.productInfo.price_display == 2) {
            return priceExTax + (priceExTax * (prestashop.productPriceBySize.productInfo.rate / 100));
        } else {
            return priceExTax;
        }
    }

    removeTax(price) {
        return price / (1 + (prestashop.productPriceBySize.productInfo.rate / 100));
    }

    applyCustomerGroupDiscount(originalPrice) {
        if (prestashop.productPriceBySize.productInfo.group_reduction > 0) {
            originalPrice = (originalPrice * (1 - (prestashop.productPriceBySize.productInfo.group_reduction / 100)));
        }
        return originalPrice;
    }

    applyExtraDiscounts(originalPrice, isAttribute) {
        let productInfo = prestashop.productPriceBySize.productInfo;
        let newPrice = originalPrice;
        if (productInfo.reduction > 0) {
            if (typeof productInfo.specific_prices !== 'undefined') {
                let price = productInfo.specific_prices.price;
                if (productInfo.specific_prices.reduction_type == 'percentage') {
                    newPrice = originalPrice - (originalPrice * (productInfo.specific_prices.reduction));
                    return newPrice;
                }

                if (productInfo.specific_prices.reduction_type == 'amount') {
                    let reduction = parseFloat(productInfo.specific_prices.reduction);
                    if (productInfo.specific_prices.reduction_tax == 0) {
                        newPrice = originalPrice - reduction;
                    } else {
                        newPrice = originalPrice - this.removeTax(reduction);
                    }
                    return newPrice;
                }
            }
        } else {
            if (productInfo.specific_prices == null) {
                return originalPrice;
            }
            if (productInfo.specific_prices.price > 0) {
                if (isAttribute) {
                    return originalPrice;
                } else {
                    return productInfo.specific_prices.price;
                }
            } else {
                return originalPrice;
            }
        }
        return originalPrice;
    }

    formatPrice(price, callback) {
        let url = MpTools.joinUrl(prestashop.productPriceBySize.urlAjax, 'action=formatPrice');
        return $.ajax({
            type: 'POST',
            url: url,
            async: true,
            cache: false,
            data: {
                'price': price
            },
            //dataType: 'json',
            success: function (resp) {
                callback(resp);
            }
        });
    }

    replaceAll(search, replace, subject) {
        return subject.split(search).join(replace);
    }

    removeFormatting(number) {
        if (number.indexOf('.') > 0) {
            number = number.replace(",", "");
        }
        else {
            number = number.replace(",", ".");
        }
        number = number.replace(/[^\d\.-]/g, '');
        if (isNaN(number)) {
            return 0;
        }
        return parseFloat(number);
    }

    calculateStepIncrement(value, step) {
        let rounded = 0;
        if (isNaN(step) || step === 0) {
            return value;
        }

        if (value.includes(',')) {
            value = parseFloat(value.replace(',', '.'));
            rounded = Math.ceil(value / step) * step;
            rounded = rounded.toString().replace('.', ',');
        } else {
            value = parseFloat(value);
            rounded = Math.ceil(value / step) * step;
        }
        return rounded;
    }

    applyRatios($sender) {
        let self = this;
        let $fieldWrapper = this.getProductFieldWrapper($sender);
        let $inputs = $(this.dom.widget.wrapper).find("input.product-field").not($sender).not('[name="pap-total-area"]');
        let baseValue = parseFloat($sender.val());
        let baseRatio = parseFloat($fieldWrapper.attr("data-ratio"));

        if (isNaN(baseValue)) {
            return;
        }

        $inputs.each(function (i, obj) {
            let $inputFieldWrapper = self.getProductFieldWrapper($(obj));
            let fieldRatio = parseFloat($inputFieldWrapper.attr("data-ratio"));
            let newValue = $(obj).val();
            if (!isNaN(fieldRatio) && fieldRatio > 0) {
                if (baseRatio > fieldRatio) {
                    newValue = (baseValue / baseRatio) * fieldRatio;
                    $(obj).val(newValue.toFixed(2));
                } else {
                    newValue = (fieldRatio / baseRatio) * baseValue;
                    $(obj).val(newValue.toFixed(2));
                }
            }
        });
        if ($sender.is('input[type="text"]')) {
            $sender.val(baseValue.toFixed(2));
        }        
    }

    parseConditions(equation) {
        let equationParsed = equation;
        let regex = /\{if(.*?)\{\/if\}/gim;
        let matches = [];
        let result;

        while ((result = regex.exec(equationParsed)) !== null) {
            matches.push(result);
        }

        for (let x=0; x <= matches.length - 1; x++) {
            var str = matches[x][1];
            var if_str = str.substr(0, str.indexOf('}'));

            var str = str.substr(str.indexOf('}') + 1);
            var results = str.split('{else}');

            if (results.length > 1) {
                //if there was an {else}
                if (eval(if_str)) {
                    result = results[0];
                } else {
                    result = results[1];
                }
                equationParsed = equationParsed.replace(matches[x][0], result);
            } else {
                if (eval(if_str)) {
                    result = results[0];
                    equationParsed = equationParsed.replace(matches[x][0], result);
                } else {
                    equationParsed = equationParsed.replace(matches[x][0], '');
                }
            }
        }
        equationParsed = equationParsed.replaceAll('ceil', 'Math.round');
        return equationParsed;
    }

    disableAddToCart() {
        $("#main form#add-to-cart-or-refresh .add-to-cart").prop('disabled', true);
    }

    enableAddToCart() {
        $("#main form#add-to-cart-or-refresh .add-to-cart").prop('disabled', false);
    }

    showFieldError($productField) {
        $productField.addClass('error');
    }

    removeFieldError($productField) {
        $productField.removeClass('error');
    }

    getWastage() {
        return parseFloat($(this.dom.widget.inputWastage + ':checked').val());
    }

    onUnitUnitSelectorChanged($sender) {
        $(this.dom.widget.divUnitSelector + ' .unit-button').removeClass('selected');
        $sender.addClass('selected');
        let displayName = $sender.attr('data-displayName');
        $(".product-field-wrapper .product-field-unit").html(displayName);
    }

    async init() {
        //$(".ppbs-widget").appendTo("#add-to-cart-or-refresh");
        $(".ppbs-widget").insertBefore(".product-add-to-cart");
    }

    events() {
        let self = this;

        $("body").on("click", this.dom.widget.divUnitSelector + ' .unit-button', function () {
            self.onUnitUnitSelectorChanged($(this));
        });

        $("body").on("change", this.dom.widget.inputWastage, function () {
            self.onFieldChanged($(this));
        });
    }
}