class PapFrontProductCoreController extends FrontProductController
{
    quickView = false;
    dom = {
        form: $('#add-to-cart-or-refresh'),
        widget: {
            inputQty : '#quantity_wanted',
            wrapper: '#pap-widget',
            divUnitSelector: '.ppbs-widget .unit-selector',
            productField: '#pap-widget .product-field',
            inputTotalArea: '#pap-widget input.total-area',
            inputData: '#ppbsFormData',
            inputWastage: '.ppbs-widget input.wastage',
            selectCoatsRequired: '#pap-widget select.coats',
            divQuotePacksRequired: '.pap-quote .pap-quote-packs-required',
            divQuoteTotalArea: '.pap-quote .pap-quote-total-area',
            divQuotePricePerPack: '.pap-quote .pap-quote-price-per-pack',
            divQuoteTotalTaxExcl: '.pap-quote .pap-quote-total-tax-exc',
            divQuoteTotalTaxIncl: '.pap-quote .pap-quote-total-tax-inc',
            btnAddWall: '#pap-widget .btn-add-wall',
            btnRemoveWall: '#pap-widget .btn-remove-wall'
        }
    }
    debounceTimer = null;

    constructor() {
        super();
    }

    async getPackInfo() {
        let query = $("#add-to-cart-or-refresh").serialize();
        let url = MpTools.joinUrl(prestashop.productPriceBySize.urlAjax, 'action=getPackInfo&' + query);

        const response = await $.ajax({
            type: 'POST',
            url: url,
            cache: false,
            data: {
                'id_product': this.getProductID(),
                'id_shop': prestashop.productPriceBySize.idShop,
            },
            dataType: 'json'
        });
        return response;
    }

    updateQty(quantity) {
        $(this.dom.widget.inputQty).val(quantity);
    }

    updateTotalArea() {
        let totalArea = this.getTotalArea(false);
        $(this.dom.widget.inputTotalArea).val(totalArea);
    }

    async loadProductData() {
        let [productPack, productInfo] = await Promise.all([this.getPackInfo(), this.getProductInfo()]);
        if (typeof productPack.idProduct !== 'undefined') {
            prestashop.productPriceBySize.productPack = productPack;
        }

        if (typeof productInfo.id_product !== 'undefined') {
            prestashop.productPriceBySize.productInfo = productInfo;
        }
    }

    showHideRemoveLink() {
        if ($('.walls .wall').length > 1) {
            $(this.dom.widget.btnRemoveWall).show();
        } else {
            $(this.dom.widget.btnRemoveWall).hide();
        }
    }

    onBtnAddWallClick($sender) {
        $('.wall').clone().appendTo('.walls');
        let $wall = $('.walls .wall:last-child');
        $wall.find('input').val('');
        this.showHideRemoveLink();
    }

    onBtnRemoveWallClick($sender) {
        $('.walls .wall:last-child').remove();
    }

    applyWastage(area) {
        let wastage = this.getWastage();
        if (wastage > 0) {
            area = (area *= 1 + (wastage / 100)).toFixed(2);
        }
        return area;
    }

    refreshQuote() {
        let self = this;
        let quoteExcVat = parseFloat(prestashop.productPriceBySize.productInfo.price_tax_exc);
        let quoteIncVat = 0;
        let quantity = this.getQuantity();
        let totalArea = this.getTotalArea(true);
        totalArea = this.applyWastage(totalArea);

        if (prestashop.productPriceBySize.productPack.isDynamicPrice === true) {
            quoteExcVat = parseFloat(quoteExcVat * prestashop.productPriceBySize.productPack.packArea * quantity).toFixed(2);
        } else {
            quoteExcVat = parseFloat(quoteExcVat * quantity);
        }
        quoteIncVat = this.addTax(quoteExcVat);

        $(this.dom.widget.divQuotePricePerPack + ' .value').html(prestashop.productPriceBySize.productInfo.price);
        $(this.dom.widget.divQuotePacksRequired + ' .value').html(quantity);
        $(this.dom.widget.divQuoteTotalArea + ' .value').html(totalArea + prestashop.productPriceBySize.unit.lang.displayName + '<sup>2</sup>');

        this.formatPrice(parseFloat(quoteExcVat), function (priceFormatted) {
            $(self.dom.widget.divQuoteTotalTaxExcl + ' .value').html(priceFormatted);
        });

        this.formatPrice(parseFloat(quoteIncVat), function (priceFormatted) {
            $(self.dom.widget.divQuoteTotalTaxIncl + ' .value').html(priceFormatted);
        });
    }

    recalculateAll() {
        this.updateData();
        let qty = this.calculateQtyRequired();
        this.updateQty(qty);
        this.updateTotalArea();
        this.refreshQuote();
    }

    async init() {
        await super.init();
        this.createDataField('ppbsFormData');
        let [productPack, productInfo] = await Promise.all([this.getPackInfo(), this.getProductInfo()]);

        if (typeof productPack.idProduct !== 'undefined') {
            prestashop.productPriceBySize.productPack = productPack;
        }

        if (typeof productInfo.id_product !== 'undefined') {
            prestashop.productPriceBySize.productInfo = productInfo;
        }
    }

    events() {
        super.events();
        const self = this;

        $("body").on("click", this.dom.widget.btnAddWall, function () {
            self.onBtnAddWallClick($(this));
            return false;
        });

        $("body").on("click", this.dom.widget.btnRemoveWall, function () {
            self.onBtnRemoveWallClick($(this));
            return false;
        });

        prestashop.on('updatedProduct', async function (event) {
            await self.loadProductData();
            self.recalculateAll();
        });
    }
}