class PapFrontProductNormalController extends PapFrontProductCoreController {
    constructor() {
        super();
        this.init();
        this.events();
    }

    calculateQtyRequired() {
        let qtyRequired = 1;
        let totalAreaConverted = this.applyWastage(this.getTotalArea(true));

        if (totalAreaConverted > 0) {
            qtyRequired = Math.ceil((totalAreaConverted / parseFloat(prestashop.productPriceBySize.productPack.packArea)).toFixed(4));
        }
        if (isNaN(qtyRequired)) {
            qtyRequired = 1;
        }
        return qtyRequired;
    }

    onFieldChanged($sender) {
        this.updateData();
        let qty = this.calculateQtyRequired();
        this.updateQty(qty);
        this.updateTotalArea();
        this.refreshQuote();
    }

    events() {
        let self = this;
        super.events();

        $("body").on("input", this.dom.widget.productField + ',' + this.dom.widget.inputTotalArea, function () {
            let $sender = $(this);
            self.debounceTimer = setTimeout(function () {
                self.onFieldChanged($sender);
            }, 500);
        });
    }
}