class PapFrontProductPaintsController extends PapFrontProductCoreController {
    constructor() {
        super();
        this.init();
        this.events();
    }

    getCoatsRequired() {
        return parseInt($(this.dom.widget.selectCoatsRequired).val());
    }

    calculateQtyRequired() {
        let qtyRequired =0;
        let totalArea = this.getTotalArea(true);
        if (totalArea > 0) {
            totalArea = this.applyWastage(totalArea);
            qtyRequired = Math.ceil(totalArea / prestashop.productPriceBySize.productPack.coverage);
            return qtyRequired * this.getCoatsRequired();
        } else {
            return 1;
        }
    }

    onFieldChanged($sender) {
        this.updateData();
        this.updateQty(this.calculateQtyRequired());
        this.refreshQuote();
    }

    events() {
        let self = this;
        super.events();

        $("body").on("input", this.dom.widget.productField + ',' + this.dom.widget.inputTotalArea, function () {
            let $sender = $(this);
            self.debounceTimer = setTimeout(function () {
                self.onFieldChanged($sender);
            }, 500);
        });
    }
}