class PapFrontProductRollsController extends PapFrontProductCoreController {
    constructor() {
        super();
        this.init();
        this.events();
    }

    getTotalWidthEntered(applyConversion) {
        let data = this.getData();
        if (data === '') {
            return 0;
        }

        let totalArea = 1;
        for (let i = 0; i <= data.fields.length - 1; i++) {
            let field = data.fields[i];
            let value = field.valueNumeric;

            if (field.dimensionName !== 'width') {
                continue;
            }

            if (isNaN(value)) {
                value = 0;
            }
            if (applyConversion) {
                value = this.convertToProductUnit(value);
            }
            totalArea = parseFloat(totalArea) * parseFloat(value);
            totalArea = parseFloat(totalArea.toPrecision(12));
        }
        return totalArea;
    }

    getTallestWall = function (applyConversion) {
        let data = this.getData();
        if (data === '') {
            return 0;
        }
        let highest = 0;
        for (let i = 0; i <= data.fields.length - 1; i++) {
            let field = data.fields[i];
            let value = field.valueNumeric;

            if (field.dimensionName !== 'height') {
                continue;
            }
            highest = Math.max(highest, parseFloat(value));
        }
        if (applyConversion) {
            highest = this.convertToProductUnit(highest);
        }
        return highest;
    };

    calculateQtyRequired() {
        let wallWidth = this.getTotalWidthEntered(true);
        let wallHeight = this.getTallestWall(true);
        let patternRepeat = parseFloat(prestashop.productPriceBySize.productPack.patternRepeat);
        let rollsRequired = 1;
        let rollHeight = parseFloat(prestashop.productPriceBySize.productPack.rollHeight);
        let rollWidth = parseFloat(prestashop.productPriceBySize.productPack.rollWidth);
        patternRepeat = 0;

        if (patternRepeat > 0) {
            let effectiveDropLength = (wallHeight / patternRepeat) * patternRepeat;
            let dropsPerRoll = rollHeight / effectiveDropLength;
            let dropsRequired = Math.ceil(wallWidth / rollWidth);

            // One roll does not cover the entire height
            if (dropsPerRoll < 1) {
                dropsPerRoll = effectiveDropLength / rollHeight;
                rollsRequired = Math.ceil(dropsPerRoll * dropsRequired);
            } else {
                rollsRequired = Math.ceil(dropsRequired / dropsPerRoll);
            }
        } else {
            let dropsPerRoll = rollHeight / wallHeight;
            let dropsRequired = Math.ceil(wallWidth / rollWidth);
            if (dropsPerRoll < 1) {
                dropsPerRoll = wallHeight / rollHeight;
                rollsRequired = Math.ceil(dropsPerRoll * dropsRequired);
            } else {
                dropsPerRoll = Math.floor(rollHeight / wallHeight);
                rollsRequired = Math.ceil(dropsRequired / dropsPerRoll);
            }
        }

        if (!isNaN(rollsRequired) && rollsRequired > 0) {
            return rollsRequired;
        } else {
            return 1;
        }
    }

    refreshQuote() {
    }

    onFieldChanged($sender) {
        this.updateData();
        this.updateQty(this.calculateQtyRequired());
    }

    events() {
        let self = this;
        super.events();

        $("body").on("input", this.dom.widget.productField + ',' + this.dom.widget.inputTotalArea, function () {
            let $sender = $(this);
            self.debounceTimer = setTimeout(function () {
                self.onFieldChanged($sender);
            }, 500);
        });
    }
}