class PpbsFrontProductController extends FrontProductController {

    quickView = false;
    dom = {
        form: $('#add-to-cart-or-refresh'),
        widget: {
            wrapper: '#ppbs-widget',
            divUnitSelector: '.ppbs-widget .unit-selector',
            productField : '#ppbs-widget .product-field',
            inputData: '#ppbsFormData',
            inputWastage: '.ppbs-widget input.wastage',
            divPpbsPrice : '#ppbs-price',
            divPpbsAreaPrice : '#ppbs-area-price',
            divStockWarning : '.ppbs-stock-warning',
        }
    }
    debounceTimer = null;
    pcoEvent = null;

    constructor() {
        super();
        this.init();
        this.events();
    }

    async init() {
        super.init();
        this.createDataField('ppbsFormData');
        let productInfo = await this.getProductInfo();
        if (typeof productInfo.id_product !== 'undefined') {
            prestashop.productPriceBySize.productInfo = productInfo;
            this.updateData();
            this.validateAllFields();                        
            this.updatePrice();            
        }
    }

    applyAreaPriceImpact(price, totalArea) {
        let returnPrice = {
            value: 0,
            impact: ''
        }
        $.each(prestashop.productPriceBySize.areaPrices, function (key, areaPrice) {
            if (totalArea >= parseFloat(areaPrice.areaLow) && totalArea <= parseFloat(areaPrice.areaHigh)) {
                if (areaPrice.impact === '-') price = price - parseFloat(areaPrice.price);
                if (areaPrice.impact === '+') price = price + parseFloat(areaPrice.price);
                if (areaPrice.impact === '*') price = price * parseFloat(areaPrice.price);
                if (areaPrice.impact === '=') price = parseFloat(areaPrice.price);
                if (areaPrice.impact === '~') price = parseFloat(areaPrice.price);
                returnPrice.value = price;
                returnPrice.impact = areaPrice.impact;
            }
        });
        return returnPrice;
    }

    getPrice(totalArea) {
        let returnPrice = {
            value: 0,
            impact: ''
        }
        let attributePrice = this.applyExtraDiscounts(prestashop.productPriceBySize.productInfo.attribute_price, true);
        returnPrice.value = parseFloat(prestashop.productPriceBySize.productInfo.base_price_exc_tax);  // Product Price only Excl Tax, attribute impact, discounts
        let price = returnPrice.value;
        let priceWithAttr = price + attributePrice;
        returnPrice = this.applyAreaPriceImpact(price, totalArea);

        let returnPriceWithAttr = this.applyAreaPriceImpact(priceWithAttr, totalArea);
        returnPrice.value_with_attr = returnPriceWithAttr.value;

        if (returnPrice.impact === '') {
            returnPrice.value = price;
        }
        return returnPrice;
    }

    getEquation() {
        if (prestashop.productPriceBySize.equations.length === 0) {
            return '';
        }

        let idProductAttribute = prestashop.productPriceBySize.productInfo.id_product_attribute;
        if (typeof prestashop.productPriceBySize.equations[idProductAttribute] !== 'undefined') {
            return prestashop.productPriceBySize.equations[idProductAttribute]['equationTemplate']['equation'];
        }
        if (typeof prestashop.productPriceBySize.equations[0] !== 'undefined') {
            return prestashop.productPriceBySize.equations[0]['equationTemplate']['equation'];
        }
        return '';
    }

    applyMinTotalArea(totalArea) {
        if (totalArea < prestashop.productPriceBySize.minTotalArea && prestashop.productPriceBySize.minTotalArea > 0) {
            totalArea = parseFloat(prestashop.productPriceBySize.minTotalArea);
        }
        return totalArea;
    }

    applyMinPrice(price) {
        if (prestashop.productPriceBySize.minPrice > 0 && price < prestashop.productPriceBySize.minPrice) {
            price = parseFloat(prestashop.productPriceBySize.minPrice);
        }
        return price;
    }

    calculatePriceFromEquation(equation) {
        let quantity = this.getQuantity();
        let equationParsed = equation;
        let data = this.getData();

        if (data === '') {
            return 0;
        }

        for (let i = 0; i <= data.fields.length - 1; i++) {
            let field = data.fields[i];
            let value = parseFloat(field.value);
            if (isNaN(value)) {
                value = 0;
            }
            equationParsed = this.replaceAll('[' + field.dimensionName + ']', field.valueNumeric, equationParsed);
        }
        let totalArea = this.applyMinTotalArea(this.getTotalArea(true));
        let priceArea = this.getPrice(this.getTotalArea(true)).value;
        priceArea = this.applyExtraDiscounts(priceArea, false);

        equationParsed = this.replaceAll('[attribute_price]', prestashop.productPriceBySize.productInfo.attribute_price, equationParsed);
        equationParsed = this.replaceAll('[base_price]', prestashop.productPriceBySize.productInfo.base_price_exc_tax, equationParsed);
        equationParsed = this.replaceAll('[product_price]', prestashop.productPriceBySize.productInfo.price_tax_exc, equationParsed);
        equationParsed = this.replaceAll('[quantity]', quantity, equationParsed);
        equationParsed = this.replaceAll('[area_price]', priceArea, equationParsed);
        equationParsed = this.replaceAll('[total_area]', totalArea, equationParsed);

        if (this.pcoEvent !== null) {
            equationParsed = this.replaceAll('[pco_price_impact]', this.pcoEvent.price_impact, equationParsed);
        } else {
            equationParsed = this.replaceAll('[pco_price_impact]', 0, equationParsed);
        }

        if (prestashop.productPriceBySize.equationVariables.length > 0) {
            for (let i = 0; i < prestashop.productPriceBySize.equationVariables.length; i++) {
                equationParsed = this.replaceAll('[' + prestashop.productPriceBySize.equationVariables[i].name + ']', prestashop.productPriceBySize.equationVariables[i].value, equationParsed);
            }
        }

        equationParsed = this.parseConditions(equationParsed);
        return parseFloat(eval(equationParsed));
    }

    stockCheck(totalArea) {
        if (prestashop.productPriceBySize.isStockEnabled) {
            if (totalArea > prestashop.productPriceBySize.productInfo.ppbs_stock) {
                $(this.dom.widget.divStockWarning).show();
                this.disableAddToCart();
            } else {
                $(this.dom.widget.divStockWarning).hide();
                this.enableAddToCart();
            }
        }
    }

    updatePrice() {
        let self = this;
        let totalAreaConverted = this.getTotalArea(true);
        let totalAreaUnconverted = this.getTotalArea(false);
        let quantity = this.getQuantity();
        let equation = this.getEquation();

        console.log(totalAreaConverted);

        this.stockCheck(totalAreaUnconverted);

        if (equation !== '') {
            let finalPrice = this.calculatePriceFromEquation(equation);
            finalPrice = this.applyMinPrice(finalPrice);
            finalPrice = finalPrice + prestashop.productPriceBySize.setupFee;
            finalPrice = this.applyCustomerGroupDiscount(parseFloat(finalPrice));
            finalPrice = this.addTax(parseFloat(finalPrice.toPrecision(8)));
            if (typeof pco_enabled !== 'undefined' && pco_enabled) {
            } else {
                this.formatPrice(parseFloat(finalPrice), function (priceFormatted) {
                    $(self.dom.widget.divPpbsPrice).html(priceFormatted);
                });
            }
            return;
        }

        // Normal calculation
        let multiplier = this.applyMinTotalArea(totalAreaUnconverted);
        let multiplierConverted = this.applyMinTotalArea(totalAreaConverted);

        let priceFinal = 0.00;
        let priceArea = 0.00;
        let price = this.getPrice(multiplierConverted * quantity);
        price.value = this.applyExtraDiscounts(price.value, false);
        price.value = this.applyCustomerGroupDiscount(parseFloat(price.value));
        let priceAttribute = this.applyExtraDiscounts(prestashop.productPriceBySize.productInfo.attribute_price, true);

        if (price.impact !== '') {
            if (price.impact === '=') {
                priceFinal = price.value;
                priceArea = price.value;
            }
            if (price.impact === '~' || price.impact === '+' || price.impact === '-' || price.impact == '*') {
                if (prestashop.productPriceBySize.isAttributePriceAreaPrice == 1) {
                    priceFinal = price.value_with_attr * multiplierConverted.toPrecision(8);
                    priceArea = price.value_with_attr;
                } else {
                    priceFinal = (price.value * multiplierConverted.toPrecision(8)) + prestashop.productPriceBySize.productInfo.attribute_price;
                    priceArea = price.value + prestashop.productPriceBySize.productInfo.attribute_price;
                }
            }
        } else {
            if (prestashop.productPriceBySize.isAttributePriceAreaPrice == 1) {
                priceFinal = (price.value + priceAttribute) * multiplierConverted.toPrecision(8);
                priceArea = (price.value + priceAttribute);
            } else {
                priceFinal = (price.value * multiplierConverted.toPrecision(8)) + priceAttribute;
                priceArea = price.value + priceAttribute;
            }
        }

        priceFinal = this.applyMinPrice(priceFinal);
        priceArea = this.applyMinPrice(priceArea);

        priceFinal = priceFinal + prestashop.productPriceBySize.setupFee;

        if (self.pcoEvent !== null) {
            priceFinal = priceFinal + self.pcoEvent.price_impact;
        }

        priceFinal = this.addTax(parseFloat(priceFinal.toPrecision(8)));
        priceFinal = priceFinal * quantity;
        priceArea = this.addTax(parseFloat(priceArea.toPrecision(8)));

        if (typeof pco_enabled !== 'undefined' && pco_enabled) {

        } else {
            this.formatPrice(parseFloat(priceFinal), function (priceFormatted) {
                $(self.dom.widget.divPpbsPrice).html(priceFormatted);
            });

            this.formatPrice(parseFloat(priceArea), function (priceFormatted) {
                if ($(".product-field-wrapper").length > 1) {
                    $(self.dom.widget.divPpbsAreaPrice).html(priceFormatted + ' / ' + prestashop.productPriceBySize.unit.lang.displayName + '²');
                } else {
                    $(self.dom.widget.divPpbsAreaPrice).html(priceFormatted);
                }
            });
        }
    }

    getProductFieldWrapper($sender) {
        return $sender.closest('.product-field-wrapper');
    }

    applyStepIncrement($sender) {
        let $wrapper = this.getProductFieldWrapper($sender);
        let step = parseFloat($wrapper.attr('data-step'));
        $sender.val(this.calculateStepIncrement($sender.val(), step));
    }

    productHasRatios() {
        for (let i=0; i <= prestashop.productPriceBySize.productFields.length - 1; i++) {
            if (prestashop.productPriceBySize.productFields[i].ratio > 0) {
                return true;
            }
        }
        return false;
    }

	truncateDecimals(value, decimals) {
		if (value.indexOf('.') > 0) {
			var pre_decimal = value.substring(0, value.indexOf('.'));
			var post_decimal = value.substring(value.indexOf('.'), value.length);
			post_decimal = post_decimal.substring(1, decimals+1);
			if (post_decimal !== '') {
				return pre_decimal + '.' + post_decimal;
			} else {
				return pre_decimal;
			}
		} else {
			return value;
		}
	};

    validateAllFields(validateEmpty, showErrors) {
        let self = this;
        let blnError = false;

        $('.product-field-wrapper').each(function () {
            let $productField = $(this).find('.product-field');
            let $fieldWrapper = self.getProductFieldWrapper($(this));
            let dataMin = self.removeFormatting($(this).attr('data-min'));
            let dataMax = self.removeFormatting($(this).attr('data-max'));
            let unitName = $(this).attr('data-unit');
            let value = self.removeFormatting($($productField).val());
            let decimals = parseInt($(this).attr('data-decimals'));
            $productField.val(self.truncateDecimals($productField.val(), decimals));

            if ($($productField).val() === '' && !validateEmpty) {
                return; // continue
            }

            let valueConverted = self.unitConversion(self.getActiveUnit(), unitName, value);
            if ((dataMin > 0 && valueConverted < dataMin) || (dataMax > 0 && valueConverted > dataMax)) {
                if (showErrors) {
                    self.showFieldError($(this));
                }
                blnError = true;
            } else {
                self.removeFieldError($(this));
            }
        });

        if (showErrors && blnError) {
            this.disableAddToCart();
        } else {
            this.enableAddToCart();
        }

        return !blnError;
    }

    events() {
        let self = this;
        super.events();

        $("body").on("input", this.dom.widget.productField, function () {
            let $sender = $(this);
            self.debounceTimer = setTimeout(function () {
                self.applyStepIncrement($sender);
                if (self.productHasRatios()) {
                    self.applyRatios($sender);
                }
                self.updateData();
                if (self.validateAllFields(true, true)) {
                    self.updateData();
                    self.updatePrice();
                }
            }, 500);
        });

        prestashop.on('updatedProduct', async function (event) {
            let productInfo = await self.getProductInfo();
            if (typeof productInfo.id_product !== 'undefined') {
                prestashop.productPriceBySize.productInfo = productInfo;
                self.updatePrice();
            }
        });

        /**
         * on product custom options price
         */
        prestashop.on('productPriceUpdated', function (event) {
            /*if (self.status === 0) {
                setTimeout(function () {
                    prestashop.emit('productPriceUpdated', event);
                }, 500);
                return false;
            }*/

            self.pcoEvent = event;
            self.updatePrice();
        });

    }
}