{* **
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
* @author    Musaffar Patel
* @copyright 2016-2025 Musaffar Patel
* @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
* *}

<div class="product-field-wrapper"
     data-id_unit="{$productField.unit.id|escape:'htmlall':'UTF-8'}"
     data-unit="{$productField.unit.name|escape:'htmlall':'UTF-8'}"
     data-step="{$productField.step|escape:'htmlall':'UTF-8'}"
     data-ratio="{$productField.ratio|escape:'htmlall':'UTF-8'}"
     data-decimals="{$productField.decimals|escape:'htmlall':'UTF-8'}"
     data-min="{$productField.min|escape:'htmlall':'UTF-8'}"
     data-max="{$productField.max|escape:'htmlall':'UTF-8'}"
     data-dimensionName="{$productField.dimension.name|escape:'htmlall':'UTF-8'}">

    <label class="field-name active">
        {$productField.dimension.lang.displayName|escape:'htmlall':'UTF-8'}
        {if !empty($productField.dimension.lang.image)}
            <span class="info-circle"></span>
            <div style="display: none" class="dimension-image">
                <img src="{$imagesUrl}large/{$productField.dimension.lang.image}" loading="lazy" style="max-width: 250px;">
            </div>
        {/if}
    </label>
    <div class="field-input-group">
        {if $productField.fieldType.name eq 'textbox'}
            <input data-id="{$productField.id|escape:'htmlall':'UTF-8'}" class="product-field textbox"
            name="ppbs-product-field-{$productField.id|escape:'htmlall':'UTF-8'}" {if $productField.defaultValue gt 0}value="{$productField.defaultValue|escape:'htmlall':'UTF-8'}"{/if}>
        {/if}
        {if $productField.fieldType.name eq 'dropdown'}
            <select data-id="{$productField.id|escape:'htmlall':'UTF-8'}" class="product-field dropdown" name="ppbs-product-field-{$productField.id|escape:'htmlall':'UTF-8'}">
                {foreach from=$productField.values item=fieldValue}
                    <option value="{$fieldValue.value|escape:'htmlall':'UTF-8'}">{$fieldValue.lang.text|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </select>
        {/if}
        <span class="product-field-unit">
            {$productField.unit.lang.displayName}
        </span>
    </div>
    <span class="error" style="display: none">
        {$productField.min|escape:'htmlall':'UTF-8'} - {$productField.max|escape:'htmlall':'UTF-8'}
    </span>
</div>