{* **
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
* @author    Musaffar Patel
* @copyright 2016-2025 Musaffar Patel
* @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
* *}

<div id="pap-widget" class="ppbs-widget">
    {include file='module:productpricebysize/views/templates/front/common/product/unit_selector.tpl'}

    <h6>{l s='Dimensions' d='Modules.Productpricebysize.Front'}</h6>

    <div class="product-fields-wrapper">
        {foreach from=$productFields item=productField}
            {include file='module:productpricebysize/views/templates/front/common/product/product_field.tpl'}
        {/foreach}
    </div>
    {include file='module:productpricebysize/views/templates/front/pap/product/partials/total_area.tpl'}
    {include file='module:productpricebysize/views/templates/front/pap/product/partials/wastage.tpl'}
    {include file='module:productpricebysize/views/templates/front/pap/product/partials/quote.tpl'}
</div>

{include file='module:productpricebysize/views/templates/front/pap/product/partials/vars.tpl'}

<script>
    if (prestashop.productPriceBySize.action === 'quickview') {
        $(document).ready(function () {
            pcoFrontProductController = new PcoFrontProductController('#pco_widget', true);
        });
    } else {
        document.addEventListener("DOMContentLoaded", function (event) {
            $(function () {
                const papFrontProductNormalController = new PapFrontProductNormalController('#pap-widget', false);
            });
        });
    }
</script>