{* **
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
* @author    Musaffar Patel
* @copyright 2016-2025 Musaffar Patel
* @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
* *}

<div id="pap-widget" class="ppbs-widget">
    {include file='module:productpricebysize/views/templates/front/common/product/unit_selector.tpl'}

    <div class="walls">
        <div class="wall">
            <div class="product-fields-wrapper">
                {foreach from=$productFields item=productField}
                    {include file='module:productpricebysize/views/templates/front/common/product/product_field.tpl'}
                {/foreach}
            </div>
        </div>
    </div>

    <div class="wall-actions">
        <a href="" class="btn-add-wall">{l s='Add a wall' d='Modules.Productpricebysize.Front'}</a>
        <a href="" class="btn-remove-wall" style="display: none">{l s='Remove a wall' d='Modules.Productpricebysize.Front'}</a>
    </div>
</div>

{include file='module:productpricebysize/views/templates/front/pap/product/partials/vars.tpl'}

<script>
    if (prestashop.productPriceBySize.action === 'quickview') {
        $(document).ready(function () {
            pcoFrontProductController = new PcoFrontProductController('#pco_widget', true);
        });
    } else {
        document.addEventListener("DOMContentLoaded", function (event) {
            $(function () {
                const papFrontProductRollsController = new PapFrontProductRollsController('#pap-widget', false);
            });
        });
    }
</script>