{* **
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
* @author    Musaffar Patel
* @copyright 2016-2025 Musaffar Patel
* @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
* *}

<div id="ppbs-widget" class="ppbs-widget">

    {include file='module:productpricebysize/views/templates/front/common/product/unit_selector.tpl'}

    <h6>{l s='Dimensions' d='Modules.Productpricebysize.Front'}</h6>

    <div class="product-fields-wrapper">
        {foreach from=$productFields item=productField}
            {include file='module:productpricebysize/views/templates/front/common/product/product_field.tpl'}
        {/foreach}
    </div>

    <div id="ppbs-price"></div>
    <div id="ppbs-area-price"></div>

    <div id="ppbs-widget-stock-warning" class="ppbs-stock-warning" style="display: none;">
        <span id="product-availability">
            <i class="material-icons product-unavailable"></i>
            {l s='Not enough available in stock' d='Modules.Productpricebysize.Front'}
        </span>
    </div>

</div>

<script>
    prestashop.productPriceBySize = {
        'action': "",
        'productInfo': {$productInfo nofilter},
        'productFields': {$productFields|json_encode nofilter},
        'unit' : {$unit nofilter},
        'units': {$units nofilter},
        'isAttributePriceAreaPrice': {$isAttributePriceAreaPrice|escape:'quotes':'UTF-8'},
        'isStockEnabled': {$isStockEnabled|escape:'quotes':'UTF-8'},
        'areaPrices': {$areaPrices nofilter},
        'minTotalArea': {$minTotalArea|escape:'quotes':'UTF-8'},
        'minPrice' : {$minPrice|escape:'quotes':'UTF-8'},
        'setupFee' : {$setupFee|escape:'quotes':'UTF-8'},
        'equations': {$equations nofilter},
        'equationVariables': {$equationVariables nofilter},
        'idShop': "{$idShop|escape:'quotes':'UTF-8' nofilter}",
        'urlAjax': "{$link->getModuleLink('productpricebysize', 'ajax', array())|escape:'quotes':'UTF-8' nofilter}",
    };

    if (prestashop.productPriceBySize.action === 'quickview') {
        $(document).ready(function () {
            pcoFrontProductController = new PcoFrontProductController('#pco_widget', true);
        });
    } else {
        document.addEventListener("DOMContentLoaded", function (event) {
            $(function () {
                const ppbsFrontProductController = new PpbsFrontProductController('#ppbs-widget', false);
            });
        });
    }
</script>
